/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractAddPropertyValueHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.ProtegeTripleAdder;
import java.util.Iterator;
import java.util.logging.Level;

class AddAnonymousClassPropertyPropertyHandler
extends AbstractAddPropertyValueHandler {
    private RDFProperty directInstancesSlot;
    private RDFProperty directTypesSlot;
    private Class javaType;
    private KnowledgeBase kb;
    private Cls newType;
    private TripleStoreModel tripleStoreModel;

    AddAnonymousClassPropertyPropertyHandler(ProtegeTripleAdder adder, Cls newType, Class javaType, TripleStoreModel tripleStoreModel) {
        super(adder);
        this.javaType = javaType;
        this.kb = newType.getKnowledgeBase();
        this.newType = newType;
        this.tripleStoreModel = tripleStoreModel;
        KnowledgeBase kb = newType.getKnowledgeBase();
        this.directInstancesSlot = new DefaultRDFProperty(kb, Model.SlotID.DIRECT_INSTANCES);
        this.directTypesSlot = new DefaultRDFProperty(kb, Model.SlotID.DIRECT_TYPES);
    }

    public void handleAdd(RDFResource subject, Object object) {
        this.removeDirectTypes(subject);
        if (subject.getClass() != this.javaType) {
            try {
                subject = (RDFResource)this.javaType.getConstructor(KnowledgeBase.class, FrameID.class).newInstance(this.kb, subject.getFrameID());
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
            this.tripleStoreModel.replaceJavaObject(subject);
        }
        if (this.adder.addValue(subject, this.directTypesSlot, this.newType)) {
            this.adder.addValueFast((Instance)this.newType, this.directInstancesSlot, subject);
        }
    }

    private void removeDirectTypes(RDFResource subject) {
        for (TripleStore tripleStore : this.tripleStoreModel.getTripleStores()) {
            Iterator vit = tripleStore.listObjects(subject, this.directTypesSlot);
            while (vit.hasNext()) {
                RDFResource type = (RDFResource)vit.next();
                tripleStore.remove(subject, this.directTypesSlot, type);
                tripleStore.remove(type, this.directInstancesSlot, subject);
            }
        }
    }
}

