/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class RDFListPostProcessor {
    public RDFListPostProcessor(OWLModel owlModel) {
        Iterator tripleStores = owlModel.getTripleStoreModel().listUserTripleStores();
        while (tripleStores.hasNext()) {
            TripleStore tripleStore = (TripleStore)tripleStores.next();
            this.process(owlModel, tripleStore);
        }
    }

    private void process(OWLModel owlModel, TripleStore tripleStore) {
        Slot directTypesSlot = owlModel.getSlot(":DIRECT-TYPE");
        Slot directInstancesSlot = owlModel.getSlot(":DIRECT-INSTANCES");
        RDFProperty rdfTypeProperty = owlModel.getRDFTypeProperty();
        owlModel.getTripleStoreModel().setActiveTripleStore(tripleStore);
        RDFSNamedClass rdfListClass = owlModel.getRDFListClass();
        RDFProperty rdfFirstProperty = owlModel.getRDFFirstProperty();
        Iterator subjects = tripleStore.listSubjects(rdfFirstProperty);
        while (subjects.hasNext()) {
            RDFResource subject = (RDFResource)subjects.next();
            if (subject.getDirectOwnSlotValues(directTypesSlot).size() != 0) continue;
            tripleStore.getNarrowFrameStore().addValues((Frame)subject, directTypesSlot, null, false, (Collection)Collections.singleton(rdfListClass));
            tripleStore.getNarrowFrameStore().addValues((Frame)rdfListClass, directInstancesSlot, null, false, (Collection)Collections.singleton(subject));
            tripleStore.add(subject, rdfTypeProperty, rdfListClass);
            if (subject instanceof RDFList) continue;
            OWLJavaFactoryUpdater.run(subject);
        }
    }
}

