/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.RelativeFolderRepository;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;

public class RelativeFolderRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel model, String s) {
        if (model.getProject() != null && model.getProject().getProjectURI() != null) {
            try {
                URI uri = new URI(s.trim());
                return !uri.isAbsolute();
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel model, String s) {
        try {
            return new RelativeFolderRepository(model.getProject().getProjectURI().toURL(), s.trim());
        }
        catch (MalformedURLException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        catch (URISyntaxException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
        return null;
    }
}

