/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.storage.KnowledgeBaseCopier;

public class OWL2OWLCopier
extends KnowledgeBaseCopier {
    private OWLModel source;
    private OWLModel target;

    public OWL2OWLCopier(OWLModel source, OWLModel target) {
        super(source, target);
        this.source = source;
        this.target = target;
    }

    protected void createClses() {
        for (OWLNamedClass oldNamedCls : this.source.getUserDefinedOWLNamedClasses()) {
            this.getNewCls(oldNamedCls);
        }
        super.createClses();
    }

    protected void createFacetOverrides(Cls oldCls) {
        if (oldCls instanceof OWLRestriction) {
            super.createFacetOverrides(oldCls);
        }
    }

    protected Instance getNewInstance(Instance oldInstance) {
        if (oldInstance instanceof OWLOntology && oldInstance.equals(this.source.getDefaultOWLOntology())) {
            return this.target.getDefaultOWLOntology();
        }
        return super.getNewInstance(oldInstance);
    }

    protected void setInitialOwnSlotValues(Instance oldInstance) {
        if (oldInstance instanceof OWLRestriction) {
            OWLRestriction oldRestriction = (OWLRestriction)oldInstance;
            OWLRestriction newRestriction = (OWLRestriction)this.getNewInstance(oldRestriction);
            this.createFacetOverrides(oldRestriction);
            this.log("+ Initialized OWLRestriction " + newRestriction.getBrowserText());
        }
    }

    protected void setOwnSlotValues(Frame newFrame, Instance oldInstance, Slot oldSlot) {
        if (newFrame instanceof OWLOntology && oldSlot.getName().equals(":OWL-ONTOLOGY-PREFIXES") && newFrame.equals(this.target.getDefaultOWLOntology())) {
            OWLOntology oi = (OWLOntology)newFrame;
            for (String prefix : this.source.getNamespaceManager().getPrefixes()) {
                String namespace = this.source.getNamespaceManager().getNamespaceForPrefix(prefix);
                this.target.getNamespaceManager().setPrefix(namespace, prefix);
            }
            this.target.getNamespaceManager().setDefaultNamespace(this.source.getNamespaceManager().getDefaultNamespace());
        } else {
            super.setOwnSlotValues(newFrame, oldInstance, oldSlot);
        }
    }
}

