/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.storage.KnowledgeBaseCopier;
import java.util.Collection;
import java.util.HashSet;

public class ProtegeSaver
extends KnowledgeBaseCopier {
    private OWLModel owlModel;

    public ProtegeSaver(KnowledgeBase source, OWLModel target) {
        super(source, target);
        this.owlModel = target;
    }

    protected void addExtraDirectTypes(Instance oldInstance, Instance newInstance) {
        super.addExtraDirectTypes(oldInstance, newInstance);
        if (oldInstance instanceof Slot && !((Slot)oldInstance).getAllowsMultipleValues() && newInstance instanceof RDFProperty) {
            ((RDFProperty)newInstance).setFunctional(true);
        }
    }

    protected Collection cloneValues(Collection oldValues) {
        Collection newValues = super.cloneValues(oldValues);
        return new HashSet(newValues);
    }

    protected Cls createCls(String clsName, Cls metaCls) {
        String validName = this.getValidName(clsName);
        this.log("+ Creating named class " + validName + " for " + clsName + " with type " + metaCls.getName());
        OWLNamedClass cls = this.owlModel.createOWLNamedClass(validName, (OWLNamedClass)metaCls);
        String realName = cls.getName();
        if (!realName.equals(clsName)) {
            cls.addLabel(clsName, null);
        }
        return cls;
    }

    protected Instance createInstance(String name, Cls newType) {
        RDFIndividual soi;
        String realName;
        String validName = this.getValidName(name);
        Instance instance = super.createInstance(validName, newType);
        if (instance instanceof RDFIndividual && !(realName = (soi = (RDFIndividual)instance).getName()).equals(name)) {
            soi.addLabel(name, null);
        }
        return instance;
    }

    protected Slot createSlot(String slotName, ValueType valueType) {
        String validName = this.getValidName(slotName);
        this.log("+ Creating slot " + validName);
        RDFProperty property = null;
        property = valueType == ValueType.INSTANCE || valueType == ValueType.CLS ? this.owlModel.createOWLObjectProperty(validName) : (valueType == ValueType.ANY ? this.owlModel.createRDFProperty(validName) : this.owlModel.createOWLDatatypeProperty(validName));
        property.removeUnionDomainClass(this.owlModel.getOWLThingClass());
        String realName = property.getName();
        if (!realName.equals(slotName)) {
            property.addLabel(slotName, null);
        }
        return property;
    }

    protected Cls getNewCls(Cls oldCls) {
        if (oldCls.getName().equals(":STANDARD-CLASS")) {
            return this.owlModel.getOWLNamedClassClass();
        }
        if (oldCls.getName().equals(":STANDARD-SLOT")) {
            return this.owlModel.getRDFPropertyClass();
        }
        if (oldCls.getName().equals(":THING")) {
            return this.owlModel.getOWLThingClass();
        }
        return super.getNewCls(oldCls);
    }

    protected Slot getNewSlot(Slot oldSlot) {
        if (oldSlot.getName().equals(":DOCUMENTATION")) {
            return this.owlModel.getRDFSCommentProperty();
        }
        if (oldSlot.getName().equals(":DIRECT-SUPERSLOTS")) {
            return this.owlModel.getRDFSSubPropertyOfProperty();
        }
        if (oldSlot.getName().equals(":SLOT-INVERSE")) {
            return this.owlModel.getRDFProperty("owl:inverseOf");
        }
        return super.getNewSlot(oldSlot);
    }

    private String getValidName(String clsName) {
        clsName = clsName.replace(':', '_');
        String suggested = AbstractOWLModel.getValidOWLFrameName((AbstractOWLModel)this.owlModel, clsName);
        int i = 1;
        while (this.owlModel.getFrame(suggested) != null) {
            suggested = AbstractOWLModel.getValidOWLFrameName((AbstractOWLModel)this.owlModel, String.valueOf(clsName) + i);
            ++i;
        }
        return suggested;
    }

    protected void setDirectType(Instance oldFrame, Instance newFrame) {
        if (oldFrame instanceof Slot && newFrame instanceof OWLProperty) {
            return;
        }
        super.setDirectType(oldFrame, newFrame);
    }

    protected void setInitialOwnSlotValues(Instance instance) {
        super.setInitialOwnSlotValues(instance);
        if (instance instanceof Slot) {
            Slot oldSlot = (Slot)instance;
            Slot oldInverseSlot = oldSlot.getInverseSlot();
            Slot newSlot = (Slot)this.getNewInstance((Instance)oldSlot);
            if (oldInverseSlot != null && newSlot != null) {
                Slot newInverseSlot = (Slot)this.getNewInstance((Instance)oldInverseSlot);
                newSlot.setInverseSlot(newInverseSlot);
            }
        }
    }

    protected void setValueType(Slot oldSlot, Slot newSlot) {
        ValueType valueType = oldSlot.getValueType();
        if (valueType != ValueType.ANY) {
            if (newSlot instanceof RDFProperty && (valueType == ValueType.BOOLEAN || valueType == ValueType.FLOAT || valueType == ValueType.INTEGER || valueType == ValueType.STRING)) {
                String uri = XMLSchemaDatatypes.getDefaultXSDDatatype(valueType).getURI();
                RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(uri);
                ((RDFProperty)newSlot).setRange(datatype);
            }
            super.setValueType(oldSlot, newSlot);
        } else {
            System.err.println("[ProtegeSaver] Warning: Slot " + oldSlot + " has value type ANY");
        }
    }
}

