/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineManager;
import edu.stanford.smi.protegex.owl.swrl.bridge.ui.ViewRuleEngineAction;
import edu.stanford.smi.protegex.owl.swrl.ui.actions.EditRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import edu.stanford.smi.protegex.owl.swrl.ui.table.CloneRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.table.CreateRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.table.DeleteRuleAction;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTable;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTableModel;
import edu.stanford.smi.protegex.owl.swrl.ui.table.ViewRuleAction;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class SWRLTablePanel
extends JPanel
implements Disposable {
    private EditRuleAction editRuleAction;
    private SWRLTable table;
    private SWRLTableModel tableModel;

    public SWRLTablePanel(OWLModel owlModel, RDFResource resource) {
        this.initialize(owlModel, resource);
    }

    public SWRLTablePanel(OWLModel owlModel, RDFResource resource, SWRLTab swrlTab) {
        LabeledComponent lc = this.initialize(owlModel, resource);
        for (SWRLRuleEngineManager.RuleEngineRegistrationInfo info : SWRLRuleEngineManager.getRegisteredRuleEngines()) {
            lc.addHeaderButton((Action)new ViewRuleEngineAction(info.getRuleEngineName(), info.getToolTip(), info.getIcon(), swrlTab, owlModel));
            this.add("Center", (Component)lc);
        }
    }

    public void dispose() {
        this.table.dispose();
    }

    private LabeledComponent initialize(OWLModel owlModel, RDFResource RDFResource2) {
        this.tableModel = RDFResource2 == null ? new SWRLTableModel(owlModel) : new SWRLTableModel(RDFResource2);
        this.table = new SWRLTable(this.tableModel, owlModel);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        OWLLabeledComponent lc = new OWLLabeledComponent("SWRL Rules", scrollPane);
        lc.addHeaderButton(new ViewRuleAction(this.table));
        lc.addHeaderButton(new CreateRuleAction(this.table, owlModel));
        lc.addHeaderButton(new CloneRuleAction(this.table, owlModel));
        lc.addHeaderButton(new DeleteRuleAction(this.table));
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
        return lc;
    }
}

