/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SymmetricPropertyMustHaveEqualRangeAndDomainTest
extends AbstractOWLTest
implements RepairableOWLTest,
RDFPropertyTest {
    public SymmetricPropertyMustHaveEqualRangeAndDomainTest() {
        super("Sanity Tests", null);
    }

    public static boolean fails(RDFProperty property) {
        if (property instanceof OWLObjectProperty && ((OWLObjectProperty)property).isSymmetric()) {
            Collection range;
            if (!property.isDomainDefined()) {
                return false;
            }
            Collection domain = property.getUnionDomain();
            return !domain.containsAll(range = property.getUnionRangeClasses()) || !range.containsAll(domain);
        }
        return false;
    }

    private String getListString(Collection items) {
        String str = "{";
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Instance instance = (Instance)it.next();
            str = String.valueOf(str) + instance.getBrowserText();
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        return String.valueOf(str) + "}";
    }

    public boolean repair(OWLTestResult testResult) {
        OWLProperty property = (OWLProperty)testResult.getHost();
        Collection domain = property.getUnionDomain();
        Collection range = property.getUnionRangeClasses();
        String message = "The current range of " + property.getBrowserText() + " is " + this.getListString(range) + "\nand its current domain is " + this.getListString(domain) + ".\nDo you want to assign the range into the domain (yes)" + "\nor do you want to assign the domain into the range (no)?";
        int option = ProtegeUI.getModalDialogFactory().showConfirmCancelDialog(ProtegeUI.getTopLevelContainer(property.getProject()), message, "Repair test failure");
        if (option == 2) {
            SymmetricPropertyMustHaveEqualRangeAndDomainTest.repairRangeIntoDomain(property);
            return true;
        }
        if (option == 3) {
            SymmetricPropertyMustHaveEqualRangeAndDomainTest.repairDomainIntoRange(property);
            return true;
        }
        return false;
    }

    public static void repairDomainIntoRange(OWLProperty property) {
        if (property.hasObjectRange()) {
            ArrayList domain = new ArrayList(property.getUnionDomain());
            property.setUnionRangeClasses(domain);
        }
    }

    public static void repairRangeIntoDomain(OWLProperty property) {
        Collection range = property.getUnionRangeClasses();
        ArrayList oldDomain = new ArrayList(property.getUnionDomain());
        for (OWLNamedClass namedCls : oldDomain) {
            property.removeUnionDomainClass(namedCls);
        }
        for (RDFSClass cls : range) {
            property.addUnionDomainClass(cls);
        }
    }

    public List test(RDFProperty property) {
        if (SymmetricPropertyMustHaveEqualRangeAndDomainTest.fails(property)) {
            return Collections.singletonList(new DefaultOWLTestResult("Symmetric properties must have equal ranges and domains.", property, 1, this));
        }
        return Collections.EMPTY_LIST;
    }
}

