/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.tests;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.MessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLoggerListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class AbstractDIGReasonerTestCase
extends AbstractJenaTestCase {
    public static final String REASONER_URL_PROPERTY = "junit.dig.url";
    private static String REASONER_URL = null;
    private static String EXPECTED_CLASSIFICATION_PROPNAME;
    private String reasoner_url = null;
    private ReasonerTaskListener tlnsr = null;
    private RDFProperty expectedClassificationProperty = null;
    private boolean haveReasoningTestAnnotations = false;
    protected ProtegeOWLReasoner reasoner = null;

    static {
        try {
            Properties jup = AbstractDIGReasonerTestCase.getJunitProperties();
            if (jup != null) {
                REASONER_URL = jup.getProperty(REASONER_URL_PROPERTY);
            }
        }
        catch (Exception e) {
            Log.getLogger().info("Reasoner not configured - tests ignored.");
        }
        EXPECTED_CLASSIFICATION_PROPNAME = "expectedClassificationStatus";
    }

    protected void setURL(String url) {
        try {
            URI uri = new URI(url);
            this.reasoner_url = uri.toString();
            Log.getLogger().info("# Reasoner URL = " + this.reasoner_url);
        }
        catch (URISyntaxException e) {
            String message = "Reasoner URL is invalid: " + e.getMessage();
            AbstractDIGReasonerTestCase.fail((String)message);
        }
    }

    protected boolean reasonerInitialized() {
        return this.reasoner_url != null;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ReasonerManager reasonerManager = ReasonerManager.getInstance();
        this.reasoner = reasonerManager.getReasoner(this.owlModel);
        ReasonerLoggerListener lsnr = new ReasonerLoggerListener(){

            public void logRecordPosted(ReasonerLogRecord reasonerLogRecord) {
                if (reasonerLogRecord instanceof MessageLogRecord) {
                    MessageLogRecord msgLog = (MessageLogRecord)reasonerLogRecord;
                    System.out.println(msgLog.getMessage());
                }
            }
        };
        ReasonerTaskListener tlnsr = new ReasonerTaskListener(){

            public void addedToTask(ReasonerTaskEvent event) {
                Log.getLogger().info(event.getSource().getMessage());
            }

            public void progressChanged(ReasonerTaskEvent event) {
                System.out.println(event.getSource().getMessage());
            }

            public void progressIndeterminateChanged(ReasonerTaskEvent event) {
                System.out.println(event.getSource().getMessage());
            }

            public void descriptionChanged(ReasonerTaskEvent event) {
                System.out.println(event.getSource().getMessage());
            }

            public void messageChanged(ReasonerTaskEvent event) {
                System.out.println(event.getSource().getMessage());
            }

            public void taskFailed(ReasonerTaskEvent event) {
                System.out.println(event.getSource().getMessage());
            }

            public void taskCompleted(ReasonerTaskEvent event) {
                System.out.println(event.getSource().getMessage());
            }
        };
        ReasonerLogger.getInstance().addListener(lsnr);
        this.setURL(REASONER_URL);
        this.reasoner.setURL(this.reasoner_url);
        String message = "Connect DIG reasoner at: '" + this.reasoner_url + "'";
        AbstractDIGReasonerTestCase.assertTrue((String)message, (boolean)this.reasoner.isConnected());
        DIGReasonerIdentity reasonerIdentity = this.reasoner.getIdentity();
        System.out.println("# Connected to " + reasonerIdentity.getName());
    }

    private void getReasoningTestAnnotations() {
        if (!this.haveReasoningTestAnnotations) {
            ArrayList annProps = new ArrayList(this.owlModel.getOWLAnnotationProperties());
            for (RDFProperty property : annProps) {
                if (!(property instanceof OWLDatatypeProperty) || property.getLocalName().compareTo(EXPECTED_CLASSIFICATION_PROPNAME) != 0) continue;
                this.expectedClassificationProperty = property;
                System.out.println("# Found annotation property: " + this.expectedClassificationProperty.getLocalName());
            }
            AbstractDIGReasonerTestCase.assertNotNull((String)"Searching for the 'expectedClassificationStatus' annotation", (Object)this.expectedClassificationProperty);
            this.haveReasoningTestAnnotations = true;
        }
    }

    protected void computeAndCheckInconsistentConcepts() {
        this.getReasoningTestAnnotations();
        try {
            this.reasoner.computeInconsistentConcepts(this.tlnsr);
        }
        catch (DIGReasonerException e) {
            String message = "Exception while checking consisntency: " + e.getMessage();
            AbstractDIGReasonerTestCase.fail((String)message);
        }
        Collection namedClses = ReasonerUtil.getInstance().getNamedClses(this.owlModel);
        int numberExpectations = 0;
        int actualExpectations = 0;
        for (OWLNamedClass curNamedCls : namedClses) {
            String clsName = curNamedCls.getLocalName();
            if (!curNamedCls.hasPropertyValue(this.expectedClassificationProperty)) continue;
            RDFSLiteral status = curNamedCls.getPropertyValueLiteral(this.expectedClassificationProperty);
            boolean expectedConsistency = status.getBoolean();
            int clsStatus = curNamedCls.getClassificationStatus();
            boolean actualConsistency = clsStatus == 3 || clsStatus == 1;
            System.out.println("# Consistency of '" + clsName + "' is expected=" + expectedConsistency + " actual=" + actualConsistency);
            ++numberExpectations;
            actualExpectations += expectedConsistency == actualConsistency ? 1 : 0;
        }
        AbstractDIGReasonerTestCase.assertEquals((String)"Expected consistency mismatch:", (int)numberExpectations, (int)actualExpectations);
    }
}

