/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;

public class ConvertIndividualToClassAction
extends ResourceAction {
    public ConvertIndividualToClassAction() {
        super("Convert individual to class", OWLIcons.getCreateIcon("PrimitiveClass"), null, true);
    }

    public void actionPerformed(ActionEvent e) {
        RDFIndividual instance = (RDFIndividual)this.getResource();
        String clsName = ConvertIndividualToClassAction.getClsName(instance);
        if (ProtegeUI.getModalDialogFactory().showConfirmDialog(this.getComponent(), "This will create a new class " + clsName + " as a subclass of " + instance.getProtegeType().getName() + "\n" + "with restrictions that represent the values of the individual\n" + "and then make this individual an instance of the new class.", "Confirm conversion")) {
            OWLModel owlModel = instance.getOWLModel();
            try {
                try {
                    owlModel.beginTransaction("Convert individual " + instance.getBrowserText() + " to class");
                    ConvertIndividualToClassAction.performAction(instance);
                }
                catch (Exception ex) {
                    ProtegeUI.getModalDialogFactory().showThrowable(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
        }
    }

    private static void createRestrictionsForValues(OWLNamedClass cls, RDFProperty property, Collection values) {
        OWLModel owlModel = cls.getOWLModel();
        for (Object value : values) {
            cls.addSuperclass(owlModel.createOWLHasValue(property, value));
        }
    }

    public static String getClsName(RDFIndividual individual) {
        String baseName;
        String name = baseName = String.valueOf(individual.getName()) + "Class";
        int i = 1;
        while (individual.getOWLModel().getRDFResource(name) != null) {
            name = String.valueOf(baseName) + i;
            ++i;
        }
        return name;
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        if (resource instanceof RDFIndividual && resource.isEditable() && !(resource instanceof SWRLIndividual) && !(resource instanceof OWLOntology)) {
            return !resource.isAnonymous();
        }
        return false;
    }

    public static OWLNamedClass performAction(RDFIndividual individual) {
        OWLModel owlModel = individual.getOWLModel();
        String name = ConvertIndividualToClassAction.getClsName(individual);
        OWLNamedClass cls = owlModel.createOWLNamedSubclass(name, (OWLNamedClass)individual.getProtegeType());
        for (RDFProperty rdfProperty : individual.getRDFProperties()) {
            Collection values;
            if (rdfProperty.equals(owlModel.getRDFTypeProperty()) || (values = individual.getPropertyValues(rdfProperty)).isEmpty()) continue;
            if (rdfProperty.isAnnotationProperty()) {
                cls.setPropertyValues(rdfProperty, values);
                continue;
            }
            ConvertIndividualToClassAction.createRestrictionsForValues(cls, rdfProperty, values);
        }
        individual.setProtegeType(cls);
        return cls;
    }
}

