/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.actions.ConvertIndividualToClassAction;

public class ConvertIndividualToClassActionTestCase
extends AbstractJenaTestCase {
    public void testDirectTypeBecomesSuperclassAndNameEquals() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        String name = "Instance";
        OWLIndividual instance = cls.createOWLIndividual("Instance");
        String newName = ConvertIndividualToClassAction.getClsName(instance);
        OWLNamedClass result = ConvertIndividualToClassAction.performAction(instance);
        ConvertIndividualToClassActionTestCase.assertEquals((String)newName, (String)result.getName());
        ConvertIndividualToClassActionTestCase.assertSize(1, result.getSuperclasses(false));
        ConvertIndividualToClassActionTestCase.assertContains((Object)cls, result.getSuperclasses(false));
        ConvertIndividualToClassActionTestCase.assertSize(1, result.getInstances(false));
        ConvertIndividualToClassActionTestCase.assertContains((Object)instance, result.getInstances(false));
    }

    public void testConvertDatatypePropertyValues() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("age", this.owlModel.getXSDint());
        property.setDomain(cls);
        String name = "Instance";
        OWLIndividual instance = cls.createOWLIndividual("Instance");
        Integer value = new Integer(42);
        instance.setPropertyValue(property, value);
        OWLNamedClass result = ConvertIndividualToClassAction.performAction(instance);
        ConvertIndividualToClassActionTestCase.assertSize(1, result.getRestrictions(false));
        OWLHasValue hasRestriction = (OWLHasValue)result.getRestrictions(false).iterator().next();
        ConvertIndividualToClassActionTestCase.assertEquals((Object)value, (Object)hasRestriction.getHasValue());
        ConvertIndividualToClassActionTestCase.assertEquals((Object)property, (Object)hasRestriction.getOnProperty());
    }

    public void testConvertObjectPropertyValues() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        property.setDomain(cls);
        String name = "Instance";
        OWLIndividual instance = cls.createOWLIndividual("Instance");
        OWLIndividual otherInstance = cls.createOWLIndividual(null);
        instance.setPropertyValue(property, otherInstance);
        OWLNamedClass result = ConvertIndividualToClassAction.performAction(instance);
        ConvertIndividualToClassActionTestCase.assertSize(1, result.getRestrictions(false));
        OWLHasValue hasRestriction = (OWLHasValue)result.getRestrictions(false).iterator().next();
        ConvertIndividualToClassActionTestCase.assertEquals((Object)otherInstance, (Object)hasRestriction.getHasValue());
        ConvertIndividualToClassActionTestCase.assertEquals((Object)property, (Object)hasRestriction.getOnProperty());
    }
}

