/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.form;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormComponent;
import edu.stanford.smi.protegex.owl.ui.classform.form.AddPropertyFormComponentAction;
import edu.stanford.smi.protegex.owl.ui.classform.form.ClassFormSeparator;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.InferredModeWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class ClassForm
extends JComponent
implements InferredModeWidget {
    private AddPropertyFormComponentAction addNecAction = new AddPropertyFormComponentAction(this);
    private AddPropertyFormComponentAction addSufAction = new AddPropertyFormComponentAction(this);
    private int colCount = 2;
    private OWLNamedClass namedClass;
    private List separators = new ArrayList();

    public ClassForm() {
        this.addMouseListener((MouseListener)new PopupMenuMouseListener(this){

            protected JPopupMenu getPopupMenu() {
                JPopupMenu menu = new JPopupMenu();
                menu.add(new JMenuItem("Test..."));
                return menu;
            }

            protected void setSelection(JComponent c, int x, int y) {
            }
        });
    }

    private void addComponents() {
        assert (this.namedClass != null);
        this.setLayout(new BoxLayout(this, 1));
        Set sufProperties = this.getSufficientProperties();
        Set necProperties = this.getNecessaryProperties(sufProperties);
        ClassFormSeparator sufSeparator = new ClassFormSeparator(true);
        ClassFormSeparator necSeparator = new ClassFormSeparator(false);
        this.separators.add(sufSeparator);
        this.separators.add(necSeparator);
        this.add(sufSeparator);
        this.add(this.getComponentWrapper(sufProperties.toArray(new RDFProperty[0]), this.addSufAction));
        this.add(necSeparator);
        this.add(this.getComponentWrapper(necProperties.toArray(new RDFProperty[0]), this.addNecAction));
    }

    public void doLayout() {
        super.doLayout();
        int i = 0;
        while (i < this.getComponentCount()) {
            Component comp = this.getComponent(i);
            comp.setBounds(0, comp.getY(), this.getWidth(), comp.getHeight());
            ++i;
        }
    }

    private Component getAddButtonComponent(ResourceSelectionAction addAction) {
        JToolBar toolBar = ComponentFactory.createToolBar();
        JButton button = ComponentFactory.addToolBarButton((JToolBar)toolBar, (Action)addAction);
        addAction.activateComboBox(button);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add("West", toolBar);
        mainPanel.add("Center", Box.createHorizontalGlue());
        return mainPanel;
    }

    private Component getComponentWrapper(RDFProperty[] properties, AddPropertyFormComponentAction action) {
        if (properties.length == 0) {
            return this.getAddButtonComponent(action);
        }
        JPanel panel = new JPanel(new GridLayout(1, this.colCount));
        Container[] cont = new Container[this.colCount];
        int i = 0;
        while (i < this.colCount) {
            cont[i] = Box.createVerticalBox();
            JPanel wrap = new JPanel(new BorderLayout());
            wrap.add("North", cont[i]);
            panel.add(wrap);
            ++i;
        }
        i = 0;
        while (i < properties.length) {
            RDFProperty property = properties[i];
            PropertyFormComponent formComponent = new PropertyFormComponent(property);
            formComponent.setNamedClass(this.namedClass);
            Container conti = cont[i % this.colCount];
            conti.add(formComponent);
            ++i;
        }
        Container container = cont[0];
        container.add(this.getAddButtonComponent(action));
        return panel;
    }

    public OWLNamedClass getNamedClass() {
        return this.namedClass;
    }

    private Set getNecessaryProperties(Set sufficientProperties) {
        HashSet<RDFProperty> result = new HashSet<RDFProperty>();
        result.addAll(this.namedClass.getUnionDomainProperties(true));
        OWLNamedClass owlThingClass = this.namedClass.getOWLModel().getOWLThingClass();
        result.removeAll(owlThingClass.getUnionDomainProperties());
        result.removeAll(sufficientProperties);
        for (RDFSClass superclass : this.namedClass.getSuperclasses(true)) {
            if (!(superclass instanceof OWLRestriction)) continue;
            result.add(((OWLRestriction)superclass).getOnProperty());
        }
        return result;
    }

    private Set getSufficientProperties() {
        HashSet<RDFProperty> result = new HashSet<RDFProperty>();
        RDFSClass definition = this.namedClass.getDefinition();
        if (definition != null) {
            if (definition instanceof OWLRestriction) {
                result.add(((OWLRestriction)definition).getOnProperty());
            } else {
                for (RDFSClass dep : definition.getDependingClasses()) {
                    if (!(dep instanceof OWLRestriction)) continue;
                    result.add(((OWLRestriction)dep).getOnProperty());
                }
            }
        }
        return result;
    }

    private void refill() {
        this.removeAll();
        if (this.namedClass != null) {
            this.addComponents();
        }
    }

    public void setInferredMode(boolean value) {
    }

    public void setNamedClass(OWLNamedClass namedClass) {
        this.namedClass = namedClass;
        this.refill();
    }
}

