/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class HierarchyPanel
extends JPanel
implements Disposable {
    private Action spawnAction = new AbstractAction("Spawn off cloned window", OWLIcons.getImageIcon("SpawnHierarchy")){

        public void actionPerformed(ActionEvent e) {
            HierarchyPanel.this.spawn();
        }
    };
    protected Hierarchy hierarchy;
    protected HierarchyManager hierarchyManager;
    private NavigationHistoryManager navigationHistoryManager;
    private Hierarchy nestedHierarchy;
    private JSplitPane nestedSplitPane;
    protected JToolBar toolBar;

    public HierarchyPanel(Hierarchy hierarchy, HierarchyManager hierarchyManager, boolean withNavigationHistory, OWLModel owlModel) {
        this.hierarchy = hierarchy;
        this.hierarchyManager = hierarchyManager;
        if (withNavigationHistory) {
            this.navigationHistoryManager = new NavigationHistoryManager(hierarchy, owlModel);
            this.navigationHistoryManager.add(owlModel.getOWLThingClass());
        }
        this.setLayout(new BorderLayout(0, 1));
        this.toolBar = OWLUI.createToolBar();
        HeaderComponent hc = hierarchy.getHeaderComponent();
        if (withNavigationHistory) {
            JButton backButton = ComponentFactory.addToolBarButton((JToolBar)this.toolBar, (Action)this.navigationHistoryManager.getBackAction(), (int)15);
            backButton.setOpaque(false);
            this.navigationHistoryManager.getBackAction().activateComboBox(backButton);
            JButton forwardButton = ComponentFactory.addToolBarButton((JToolBar)this.toolBar, (Action)this.navigationHistoryManager.getForwardAction(), (int)15);
            forwardButton.setOpaque(false);
            this.navigationHistoryManager.getForwardAction().activateComboBox(forwardButton);
            this.toolBar.addSeparator();
        }
        ComponentFactory.addToolBarButton((JToolBar)this.toolBar, (Action)this.spawnAction, (int)15).setOpaque(false);
        Container hp = (Container)hc.getComponent(0);
        this.toolBar.setBackground(hp.getBackground());
        hp.add("East", this.toolBar);
        hc.setTitle(hierarchy.getType());
        this.add("Center", (Component)((Object)hierarchy));
        this.setMinimumSize(new Dimension(40, 40));
    }

    public void dispose() {
        if (this.navigationHistoryManager != null) {
            this.navigationHistoryManager.dispose();
        }
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Hierarchy getNestedHierarchy() {
        return this.nestedHierarchy;
    }

    public String getTitle() {
        return this.hierarchy.getTitle();
    }

    public boolean isSynchronized() {
        return true;
    }

    public void setNestedHierarchy(Hierarchy newNestedHierarchy) {
        if (newNestedHierarchy != null) {
            Component top = (Component)((Object)this.hierarchy);
            int height = top.getHeight();
            Component bottom = (Component)((Object)newNestedHierarchy);
            this.nestedSplitPane = new JSplitPane(0, top, bottom);
            this.removeAll();
            this.add("Center", this.nestedSplitPane);
            this.revalidate();
            this.nestedSplitPane.setDividerLocation(height - 150);
            this.nestedSplitPane.setResizeWeight(1.0);
            this.revalidate();
            newNestedHierarchy.addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent event) {
                    RDFSClass sel = HierarchyPanel.this.nestedHierarchy.getSelectedClass();
                    if (sel != null) {
                        HierarchyPanel.this.hierarchy.setSelectedClass(sel);
                    }
                }
            });
        } else if (this.nestedSplitPane != null) {
            ComponentUtilities.dispose((Component)this.nestedSplitPane.getBottomComponent());
            this.removeAll();
            this.add("Center", (Component)((Object)this.hierarchy));
            this.nestedSplitPane = null;
            this.revalidate();
        }
        this.nestedHierarchy = newNestedHierarchy;
    }

    private void spawn() {
        Hierarchy clonedHierarchy = this.hierarchy.createClone();
        this.hierarchyManager.spawnHierarchy(clonedHierarchy);
    }
}

