/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.Component;
import java.util.Collection;

public class ClassDescriptionTable
extends OWLTable {
    ClassDescriptionTable(OWLModel owlModel, OWLTableModel tableModel) {
        super(tableModel, owlModel, true);
        this.setColumnWidths();
    }

    void addCls(RDFSClass aClass) {
        OWLTableModel compactOWLTableModel = this.getOWLTableModel();
        if (compactOWLTableModel.getClassRow(aClass) >= 0) {
            compactOWLTableModel.displaySemanticError("The class " + aClass.getBrowserText() + " is already in the list.");
        } else if (aClass.equals(compactOWLTableModel.getEditedCls())) {
            compactOWLTableModel.displaySemanticError("Cannot assign " + aClass.getBrowserText() + " to itself.");
        } else {
            OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
            compactOWLTableModel.addRow(aClass, this.getSelectedRow());
            int row = compactOWLTableModel.getClassRow(aClass);
            if (row >= 0) {
                this.getSelectionModel().setSelectionInterval(row, row);
            }
            if (tab != null) {
                tab.ensureClassSelected(this.getEditedCls(), -1);
            }
        }
    }

    void createAndEditRow() {
        int row = this.getOWLTableModel().addEmptyRow(-1);
        this.editExpression(row);
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel model, SymbolErrorDisplay errorDisplay) {
        return new ClassDescriptionEditorComponent(model, errorDisplay, false);
    }

    public void hideSymbolPanel() {
        super.hideSymbolPanel();
        this.getOWLTableModel().removeEmptyRow();
    }

    private void setColumnWidths() {
        this.getColumnModel().getColumn(this.getOWLTableModel().getSymbolColumnIndex()).setPreferredWidth(350);
    }

    void toggleSuperClsIntoDefintion() {
        int sel = this.getSelectedRow();
        if (sel >= 0) {
            OWLNamedClass cls = this.getOWLTableModel().getEditedCls();
            RDFSClass superClass = this.getOWLTableModel().getClass(sel);
            this.toggleSuperclassIntoEquivalentClass(cls, superClass);
            this.getSelectionModel().setSelectionInterval(sel, sel);
        }
    }

    void toggleDefinitionIntoSuperCls() {
        int sel = this.getSelectedRow();
        if (sel >= 0) {
            OWLNamedClass cls = this.getOWLTableModel().getEditedCls();
            RDFSClass superClass = this.getOWLTableModel().getClass(sel);
            this.toggleEquivalentClassIntoSuperclass(cls, superClass);
            this.getSelectionModel().setSelectionInterval(sel, sel);
        }
    }

    private void toggleEquivalentClassIntoSuperclass(OWLNamedClass cls, RDFSClass superClass) {
        OWLUtil.convertEquivalentClsIntoSuperClses(cls, superClass);
    }

    private void toggleSuperclassIntoEquivalentClass(OWLNamedClass cls, RDFSClass superClass) {
        Collection namedDirectSuperclasses = cls.getNamedSuperclasses();
        namedDirectSuperclasses.remove(superClass);
        if (namedDirectSuperclasses.size() == 0) {
            cls.addSuperclass(this.getOWLModel().getOWLThingClass());
        }
        OWLUtil.convertSuperClsIntoEquivalentCls(cls, superClass);
    }
}

