/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.clsdesc.PropertiesSuperclassesTableModel;

public class PropertiesClassesTableModelTestCase
extends AbstractJenaTestCase {
    public void testFill() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", superCls);
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(otherCls);
        cls.addSuperclass(complementCls);
        PropertiesSuperclassesTableModel tableModel = new PropertiesSuperclassesTableModel();
        tableModel.setCls(cls);
        PropertiesClassesTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        PropertiesClassesTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        PropertiesClassesTableModelTestCase.assertEquals((Object)complementCls, (Object)tableModel.getClass(1));
    }

    public void testAddsRemoveAndDelete() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", superCls);
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        PropertiesSuperclassesTableModel tableModel = new PropertiesSuperclassesTableModel();
        tableModel.setCls(cls);
        PropertiesClassesTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertiesClassesTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        PropertiesClassesTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(superCls));
        PropertiesClassesTableModelTestCase.assertFalse((boolean)tableModel.isDeleteEnabledFor(superCls));
        tableModel.addEmptyRow(1);
        tableModel.setValueAt("Other", 1, 0);
        tableModel.removeEmptyRow();
        PropertiesClassesTableModelTestCase.assertTrue((boolean)cls.isSubclassOf(otherCls));
        PropertiesClassesTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        PropertiesClassesTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(otherCls));
        PropertiesClassesTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(superCls));
        tableModel.addEmptyRow(2);
        tableModel.setValueAt("not Other", 2, 0);
        tableModel.removeEmptyRow();
        PropertiesClassesTableModelTestCase.assertEquals((int)3, (int)tableModel.getRowCount());
        OWLComplementClass complementCls = (OWLComplementClass)tableModel.getClass(2);
        PropertiesClassesTableModelTestCase.assertTrue((boolean)cls.isSubclassOf(complementCls));
        PropertiesClassesTableModelTestCase.assertTrue((boolean)tableModel.isDeleteEnabledFor(complementCls));
        PropertiesClassesTableModelTestCase.assertEquals((Object)otherCls, (Object)complementCls.getComplement());
        PropertiesClassesTableModelTestCase.assertEquals((Object)otherCls, (Object)tableModel.getClass(0));
        tableModel.deleteRow(0);
        PropertiesClassesTableModelTestCase.assertFalse((boolean)cls.isSubclassOf(otherCls));
        tableModel.deleteRow(1);
        PropertiesClassesTableModelTestCase.assertFalse((boolean)cls.isSubclassOf(complementCls));
        PropertiesClassesTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
    }

    public void testUpdateOnExternalChange() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("SuperCls");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", superCls);
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        PropertiesSuperclassesTableModel tableModel = new PropertiesSuperclassesTableModel();
        tableModel.setCls(cls);
        PropertiesClassesTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertiesClassesTableModelTestCase.assertEquals((Object)superCls, (Object)tableModel.getClass(0));
        cls.addSuperclass(otherCls);
        PropertiesClassesTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
    }
}

