/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;

public class PropertyRestrictionsTreeRenderer
extends ResourceRenderer {
    private boolean displayRestrictions;
    private boolean expanded;
    private boolean hideGlobalCharacteristics = true;
    private Cls originCls;

    public PropertyRestrictionsTreeRenderer(boolean displayRestrictions, boolean hideGlobalCharacteristics) {
        this.displayRestrictions = displayRestrictions;
        this.hideGlobalCharacteristics = hideGlobalCharacteristics;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.expanded = expanded;
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    public void load(Object value) {
        if (value instanceof RestrictionTreeNode) {
            Object filler;
            RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)value;
            Icon icon = restrictionTreeNode.getIcon();
            this.clear();
            this.setMainIcon(icon);
            this.setMainText(restrictionTreeNode.getFillerText());
            this.originCls = restrictionTreeNode.getInheritedFromClass();
            Object userObject = restrictionTreeNode.getUserObject();
            if (userObject instanceof OWLQuantifierRestriction) {
                RDFResource filler2 = ((OWLQuantifierRestriction)userObject).getFiller();
                if (filler2 instanceof OWLClass) {
                    this.loadedClass = (OWLClass)filler2;
                }
            } else if (userObject instanceof OWLCardinalityBase) {
                RDFSClass filler3 = ((OWLCardinalityBase)userObject).getQualifier();
                if (filler3 instanceof OWLClass) {
                    this.loadedClass = (OWLClass)filler3;
                }
            } else if (userObject instanceof OWLHasValue && (filler = ((OWLHasValue)userObject).getHasValue()) instanceof OWLClass) {
                this.loadedClass = (OWLClass)filler;
            }
        } else if (value instanceof PropertyTreeNode) {
            PropertyTreeNode treeNode = (PropertyTreeNode)value;
            RDFProperty property = treeNode.getRDFProperty();
            Icon icon = treeNode.getIcon();
            this.setMainIcon(icon);
            String mainText = property.getBrowserText();
            this.setMainText(mainText);
            this.originCls = null;
            if (!this.hideGlobalCharacteristics) {
                boolean allValuesFromRestriction;
                RDFSNamedClass allRestrictionMetaCls = property.getOWLModel().getRDFSNamedClass("owl:AllValuesFromRestriction");
                boolean bl = allValuesFromRestriction = this.displayRestrictions && treeNode.hasRestrictionOfType(allRestrictionMetaCls);
                if (!allValuesFromRestriction) {
                    String prefix;
                    RDFResource range = property.getRange(true);
                    String string = prefix = property.isFunctional() ? "single" : "multiple";
                    if (range != null) {
                        this.addText("    (" + prefix + " " + range.getBrowserText() + ")");
                    } else if (property.isFunctional()) {
                        this.addText("    (" + prefix + ")");
                    }
                }
            }
            if (this.displayRestrictions && treeNode.getChildCount() > 0) {
                this.addText("     (");
                int i = 0;
                while (i < treeNode.getChildCount()) {
                    RestrictionTreeNode restrictionTreeNode = (RestrictionTreeNode)treeNode.getChildAt(i);
                    this.addText(String.valueOf(restrictionTreeNode.getOperatorName()) + " ");
                    this.addText(restrictionTreeNode.getFillerText());
                    if (i < treeNode.getChildCount() - 1) {
                        this.addText(",  ");
                    }
                    ++i;
                }
                this.addText(")");
            }
        } else {
            super.load(value);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        int width = this.getWidth();
        FontMetrics fm = this._fontMetrics;
        int mainTextLength = fm.stringWidth(this.getMainText());
        int ascent = fm.getAscent();
        if (this.originCls != null) {
            String browserText = this.originCls.getBrowserText();
            String str = "[from " + browserText + "]";
            int strWidth = fm.stringWidth(str);
            int c = browserText.length();
            int x = width - 3;
            while (c > 3 && x - strWidth - 2 <= mainTextLength + 4) {
                str = "[from " + browserText.substring(0, --c) + "...]";
                strWidth = fm.stringWidth(str);
            }
            if (x - strWidth - 2 > mainTextLength + 4) {
                g.setColor(Color.gray);
                g.drawString(str, x - strWidth - 2, ascent);
            }
        }
    }
}

