/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class SymbolCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor,
SymbolEditorHandler {
    private SymbolEditorComponent editorComponent;

    public SymbolCellEditor(SymbolEditorComponent editorComponent) {
        this.editorComponent = editorComponent;
    }

    public Object getCellEditorValue() {
        return this.editorComponent.getTextComponent().getText();
    }

    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2 && !SwingUtilities.isRightMouseButton((MouseEvent)e);
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editorComponent.getTextComponent().setText(value != null ? value.toString() : "");
        this.editorComponent.getTextComponent().requestFocus();
        return this.editorComponent;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.editorComponent.getTextComponent().setText(value != null ? value.toString() : "");
        this.editorComponent.requestFocus();
        return this.editorComponent;
    }

    public void stopEditing() {
        this.stopCellEditing();
    }

    public void cancelEditing() {
        this.cancelCellEditing();
    }
}

