/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;

public class AddTodoAction
extends AbstractAction {
    private TriplesTable table;

    public AddTodoAction(TriplesTable table) {
        super("Add TODO list item", OWLIcons.getCreateIcon("TodoAnnotation"));
        this.table = table;
    }

    public void actionPerformed(ActionEvent e) {
        TriplesTableModel tableModel = this.table.getTableModel();
        OWLModel owlModel = tableModel.getOWLModel();
        OWLDatatypeProperty todoProperty = owlModel.getTodoAnnotationProperty();
        String prefix = owlModel.getTodoAnnotationPrefix();
        String value = String.valueOf(prefix) + ": ";
        Collection existingValues = tableModel.getSubject().getPropertyValues(todoProperty);
        while (existingValues.contains(value)) {
            value = String.valueOf(value) + "-";
        }
        tableModel.getSubject().addPropertyValue(todoProperty, value);
        int row = tableModel.getPropertyValueRow(todoProperty, value);
        this.table.getSelectionModel().setSelectionInterval(row, row);
        this.table.editCell(row);
    }
}

