/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class AddResourceAction
extends ResourceSelectionAction {
    private TriplesTable table;

    public AddResourceAction(TriplesTable table) {
        this(table, "Add existing resource as value...", OWLIcons.getAddIcon("RDFIndividual"));
    }

    public AddResourceAction(TriplesTable table, String name, Icon icon) {
        super(name, icon);
        this.table = table;
    }

    protected Collection getAllowedProperties(OWLModel owlModel) {
        return owlModel.getRDFProperties();
    }

    public Collection getSelectableResources() {
        TriplesTableModel tableModel = this.table.getTableModel();
        OWLModel owlModel = tableModel.getOWLModel();
        ArrayList<RDFProperty> properties = new ArrayList<RDFProperty>();
        Collection allowedProperties = this.getAllowedProperties(owlModel);
        for (RDFProperty property : allowedProperties) {
            if (!property.isVisible() || !property.hasObjectRange() || property.isSystem()) continue;
            properties.add(property);
        }
        properties.add(owlModel.getOWLDisjointWithProperty());
        properties.add(owlModel.getOWLDifferentFromProperty());
        properties.add(owlModel.getOWLEquivalentPropertyProperty());
        properties.add(owlModel.getOWLSameAsProperty());
        properties.add(owlModel.getRDFProperty("rdfs:isDefinedBy"));
        properties.add(owlModel.getRDFProperty("rdfs:seeAlso"));
        return properties;
    }

    public void resourceSelected(RDFResource resource) {
        TriplesTableModel tableModel = this.table.getTableModel();
        OWLModel owlModel = tableModel.getOWLModel();
        RDFProperty property = (RDFProperty)resource;
        if (property.hasObjectRange()) {
            owlModel.getRDFUntypedResourcesClass().setVisible(true);
            Collection unionRangeClasses = property.getUnionRangeClasses();
            if (unionRangeClasses.isEmpty()) {
                unionRangeClasses = Collections.singleton(owlModel.getOWLThingClass());
            }
            RDFResource value = ProtegeUI.getSelectionDialogFactory().selectResourceByType(this.table, owlModel, unionRangeClasses);
            owlModel.getRDFUntypedResourcesClass().setVisible(false);
            this.tryToAddValue(property, value);
        } else {
            int row = tableModel.addRow(property);
            this.table.editCell(row);
        }
    }

    public RDFResource pickResource() {
        TriplesTableModel tableModel = this.table.getTableModel();
        OWLModel owlModel = tableModel.getOWLModel();
        Collection properties = this.getSelectableResources();
        return ProtegeUI.getSelectionDialogFactory().selectProperty(this.table, owlModel, properties);
    }

    private void tryToAddValue(RDFProperty property, RDFResource value) {
        if (value != null) {
            TriplesTableModel tableModel = this.table.getTableModel();
            if (tableModel.getSubject().getPropertyValues(property).contains(value)) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.table, "This value is already used.");
            } else {
                int row = tableModel.addRow(property, value);
                this.table.getSelectionModel().setSelectionInterval(row, row);
                this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
            }
        }
    }
}

