/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.PropertyConditionsDisplay;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public abstract class AbstractConditionsWidget
extends AbstractPropertyWidget
implements ConditionsTableConstants,
PropertyConditionsDisplay {
    protected ConditionsTable table;
    protected ConditionsTableModel tableModel;
    private OWLTableAction viewAction = new AbstractOWLTableAction("View/edit class", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            Cls cls = AbstractConditionsWidget.this.table.getSelectedCls();
            if (cls != null) {
                AbstractConditionsWidget.this.showInstance((Instance)cls);
            }
        }

        public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
            return cls instanceof RDFSNamedClass;
        }
    };

    public void displayRowsWithProperty(OWLProperty property) {
        this.table.displayRowsWithProperty(property);
    }

    protected OWLClassesTab getClsesTab() {
        return OWLClassesTab.getOWLClassesTab((Component)((Object)this));
    }

    protected OWLNamedClass getEditedCls() {
        return (OWLNamedClass)this.getEditedResource();
    }

    public ConditionsTable getTable() {
        return this.table;
    }

    protected void initialize(String label, Slot superclassesSlot) {
        OWLModel owlModel = (OWLModel)this.getKnowledgeBase();
        this.tableModel = new ConditionsTableModel(superclassesSlot);
        this.table = new ConditionsTable(owlModel, this.tableModel);
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        OWLLabeledComponent labeledComponent = new OWLLabeledComponent(label, scrollPane, true, true);
        this.initializeButtons(labeledComponent);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)labeledComponent));
    }

    protected void initializeButtons(LabeledComponent labeledComponent) {
        WidgetUtilities.addViewButton(labeledComponent, this.viewAction);
    }

    private void navigateToCls(RDFSNamedClass rdfsClass) {
        OWLClassesTab tab = this.getClsesTab();
        if (tab != null) {
            tab.setSelectedCls(rdfsClass);
        }
    }

    public void refresh() {
        this.tableModel.refresh();
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (this.table != null) {
            if (newInstance instanceof OWLNamedClass) {
                this.table.setCls((OWLNamedClass)newInstance);
                this.tableModel.setCls((OWLNamedClass)newInstance);
            } else {
                this.tableModel.setCls(null);
            }
        }
    }
}

