/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.HashSet;
import java.util.Set;

public class ExistentialFillerProvider
extends OWLModelVisitorAdapter {
    private Set fillers = new HashSet();
    private Set visitedResources = new HashSet();
    private Set properties = new HashSet();

    public ExistentialFillerProvider(OWLObjectProperty property) {
        this.properties.add(property);
        this.properties.addAll(property.getSubproperties(true));
    }

    public void reset() {
        this.fillers.clear();
        this.visitedResources.clear();
    }

    public Set getFillers() {
        return this.fillers;
    }

    public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
        if (this.visitedResources.contains(owlNamedClass)) {
            return;
        }
        this.visitedResources.add(owlNamedClass);
        for (Object o : owlNamedClass.getSuperclasses(false)) {
            if (!(o instanceof OWLClass)) continue;
            ((OWLClass)o).accept(this);
        }
        for (Object o : owlNamedClass.getEquivalentClasses()) {
            if (!(o instanceof OWLClass)) continue;
            ((OWLClass)o).accept(this);
        }
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass owlIntersectionClass) {
        for (Object o : owlIntersectionClass.getOperands()) {
            if (!(o instanceof OWLClass)) continue;
            ((OWLClass)o).accept(this);
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom someValuesFrom) {
        if (this.properties.contains(someValuesFrom.getOnProperty())) {
            this.processFiller((OWLObjectProperty)someValuesFrom.getOnProperty(), (OWLClass)someValuesFrom.getFiller());
        }
    }

    public void visitOWLMinCardinality(OWLMinCardinality owlMinCardinality) {
        this.processCardinality(owlMinCardinality);
    }

    public void visitOWLCardinality(OWLCardinality owlCardinality) {
        this.processCardinality(owlCardinality);
    }

    private void processCardinality(OWLCardinalityBase cardinalityBase) {
        if (cardinalityBase.getCardinality() > 0 && this.properties.contains(cardinalityBase.getOnProperty()) && cardinalityBase.getValuesFrom() != null && cardinalityBase.getValuesFrom() instanceof OWLClass) {
            this.processFiller((OWLObjectProperty)cardinalityBase.getOnProperty(), (OWLClass)cardinalityBase.getValuesFrom());
        }
    }

    private void processFiller(OWLObjectProperty property, OWLClass cls) {
        if (cls instanceof OWLIntersectionClass) {
            OWLIntersectionClass fillerCls = (OWLIntersectionClass)cls;
            for (Object o : fillerCls.getOperands()) {
                if (!(o instanceof OWLClass)) continue;
                OWLClass curOp = (OWLClass)o;
                this.fillers.add(curOp);
                if (!property.isTransitive()) continue;
                curOp.accept(this);
            }
        } else {
            this.fillers.add(cls);
            if (property.isTransitive()) {
                cls.accept(this);
            }
        }
    }
}

