/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.existential.Existential;
import java.util.List;

public class ExistentialTestCase
extends AbstractJenaTestCase {
    public void test1DirectSuperclasses() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasPart");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        hostCls.addSuperclass(bCls);
        hostCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, aCls));
        List ts = Existential.getExistentialDependents(hostCls, property);
        ExistentialTestCase.assertSize(1, ts);
        ExistentialTestCase.assertEquals((Object)aCls, ts.get(0));
    }

    public void test2DirectSuperclasses() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasPart");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        hostCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, bCls));
        hostCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, aCls));
        List ts = Existential.getExistentialDependents(hostCls, property);
        ExistentialTestCase.assertSize(2, ts);
        ExistentialTestCase.assertEquals((Object)aCls, ts.get(0));
        ExistentialTestCase.assertEquals((Object)bCls, ts.get(1));
    }

    public void testAncestorClasses() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasPart");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        aCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, bCls));
        hostCls.addSuperclass(aCls);
        List ts = Existential.getExistentialDependents(hostCls, property);
        ExistentialTestCase.assertSize(1, ts);
        ExistentialTestCase.assertEquals((Object)bCls, ts.get(0));
    }

    public void test1EquivalentClass() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("hasPart");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass bCls = this.owlModel.createOWLNamedClass("B");
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(bCls);
        intersectionCls.addOperand(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, aCls));
        hostCls.addEquivalentClass(intersectionCls);
        List ts = Existential.getExistentialDependents(hostCls, property);
        ExistentialTestCase.assertSize(1, ts);
        ExistentialTestCase.assertEquals((Object)aCls, ts.get(0));
    }
}

