/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer;

import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreeNodeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public abstract class ExplorerTreeNode
extends LazyTreeNode {
    protected ExplorerFilter filter;
    private ClassListener listener = new ClassAdapter(){

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            ExplorerTreeNode.this.updateChildren();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            ExplorerTreeNode.this.updateChildren();
        }
    };

    public ExplorerTreeNode(LazyTreeNode parent, RDFSClass cls, ExplorerFilter filter) {
        super(parent, (Object)cls);
        cls.addClassListener(this.listener);
        this.filter = filter;
    }

    protected abstract List createChildObjects();

    protected LazyTreeNode createNode(Object o) {
        return ExplorerTreeNodeFactory.create(this, (RDFSClass)o, this.filter);
    }

    private void deleteChildren() {
        super.dispose();
    }

    public void dispose() {
        this.getRDFSClass().removeClassListener(this.listener);
        this.deleteChildren();
    }

    protected Collection getChildObjects() {
        ArrayList<RDFSClass> results = new ArrayList<RDFSClass>();
        for (RDFSClass childClass : this.createChildObjects()) {
            if (!this.filter.isValidChild(this.getRDFSClass(), childClass)) continue;
            results.add(childClass);
        }
        return results;
    }

    protected int getChildObjectCount() {
        return this.getChildObjects().size();
    }

    public ExplorerTreeNode getChildNode(int index) {
        return (ExplorerTreeNode)((Object)this.getChildAt(index));
    }

    protected Comparator getComparator() {
        return null;
    }

    public RDFSClass getRDFSClass() {
        return (RDFSClass)this.getUserObject();
    }

    public String toString(boolean expanded) {
        return this.getRDFSClass().getBrowserText();
    }

    private void updateChildren() {
        this.reload();
    }
}

