/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MatrixTable
extends JTable {
    private MatrixTableModel tableModel;

    public MatrixTable(MatrixTableModel aTableModel) {
        this.tableModel = aTableModel;
        this.tableModel.setTable(this);
        this.setModel(aTableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getSelectionModel().setSelectionMode(0);
        this.setRowHeight(Math.max(this.getFontMetrics(this.getFont()).getHeight(), 16));
        this.initColumns();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MatrixTable.this.handleDoubleClick();
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupMenuMouseListener(this){

            protected JPopupMenu getPopupMenu() {
                JPopupMenu popupMenu = new JPopupMenu();
                int sel = MatrixTable.this.getSelectedRow();
                if (sel >= 0 && sel < MatrixTable.this.tableModel.getRowCount()) {
                    ResourceActionManager.addResourceActions(popupMenu, (Component)MatrixTable.this, MatrixTable.this.tableModel.getInstance(sel));
                }
                if (popupMenu.getComponentCount() > 0) {
                    return popupMenu;
                }
                return null;
            }

            protected void setSelection(JComponent c, int x, int y) {
                int row = y / MatrixTable.this.getRowHeight();
                if (row >= 0 && row < MatrixTable.this.tableModel.getRowCount()) {
                    MatrixTable.this.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JTableHeader h = (JTableHeader)e.getSource();
                TableColumnModel columnModel = h.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = columnModel.getColumn(viewColumn).getModelIndex();
                if (MatrixTable.this.tableModel.isSortableColumn(column)) {
                    MatrixTable.this.setSortColumn(column);
                }
            }
        });
    }

    public void addColumn(MatrixColumn col) {
        int index = this.tableModel.getNewColumnIndex(col);
        this.tableModel.addColumn(col, index);
        this.addColumn(new TableColumn(index));
        this.initColumns();
        this.getTableHeader().repaint();
    }

    public void close() {
        Container c = this.getParent();
        while (c != null && !(c instanceof ResultsPanel)) {
            c = c.getParent();
        }
        if (c != null) {
            ResultsPanel panel = (ResultsPanel)c;
            panel.close();
        }
    }

    public TableCellEditor getCellEditor(int row, int column) {
        MatrixColumn col = this.tableModel.getMatrixColumn(column);
        if (col instanceof EditableMatrixColumn) {
            return ((EditableMatrixColumn)col).getTableCellEditor();
        }
        return super.getCellEditor();
    }

    public void initColumns() {
        int i = 0;
        while (i < this.tableModel.getColumnCount()) {
            MatrixColumn col = this.tableModel.getMatrixColumn(i);
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setHeaderValue(col.getName());
            column.setCellRenderer(col.getCellRenderer());
            column.setPreferredWidth(col.getWidth());
            ++i;
        }
    }

    private void handleDoubleClick() {
        int sel = this.getSelectedRow();
        if (sel >= 0 && sel < this.tableModel.getRowCount()) {
            RDFResource instance = this.tableModel.getInstance(sel);
            ResultsPanelManager.showHostResource(instance);
        }
    }

    private void setSortColumn(int column) {
        this.tableModel.setSortColumn(column);
        this.initColumns();
    }

    public RDFResource getSelectedInstance() {
        int sel = this.getSelectedRow();
        if (sel >= 0) {
            return this.tableModel.getInstance(sel);
        }
        return null;
    }
}

