/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.writersettings.JenaWriterSettings;
import edu.stanford.smi.protegex.owl.jena.writersettings.WriterSettings;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WriterSettingsPanel
extends JComponent {
    private JenaOWLModel owlModel;
    private JRadioButton jenaButton;
    private JRadioButton protegeButton;
    private JCheckBox sortAlphabeticallyBox;
    private WriterSettings writerSettings;
    private JCheckBox useXMLEntitiesBox;

    public WriterSettingsPanel(JenaOWLModel owlModel) {
        this.owlModel = owlModel;
        this.jenaButton = new JRadioButton("Default Jena writer");
        this.protegeButton = new JRadioButton("Experimental native writer");
        this.writerSettings = owlModel.getWriterSettings();
        if (this.writerSettings instanceof JenaWriterSettings) {
            this.jenaButton.setSelected(true);
        } else {
            this.protegeButton.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.jenaButton);
        group.add(this.protegeButton);
        this.sortAlphabeticallyBox = new JCheckBox("Sort resources alphabetically");
        this.sortAlphabeticallyBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriterSettingsPanel.this.setSortAlphabetically(WriterSettingsPanel.this.sortAlphabeticallyBox.isSelected());
            }
        });
        this.useXMLEntitiesBox = new JCheckBox("Use XML entities");
        this.useXMLEntitiesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriterSettingsPanel.this.setUseXMLEntities(WriterSettingsPanel.this.useXMLEntitiesBox.isSelected());
            }
        });
        this.jenaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriterSettingsPanel.this.setJenaWriterSettings();
            }
        });
        this.protegeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriterSettingsPanel.this.setProtegeWriterSettings();
            }
        });
        JPanel mainPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder("RDF/XML Writer Settings"));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.jenaButton);
        mainPanel.add(this.protegeButton);
        this.setLayout(new BorderLayout());
        Box protegePanel = Box.createVerticalBox();
        protegePanel.add(this.useXMLEntitiesBox);
        protegePanel.add(this.sortAlphabeticallyBox);
        this.updateProtegePanel();
        this.add("West", mainPanel);
        this.add("Center", new JPanel());
        this.add("East", protegePanel);
    }

    private void setJenaWriterSettings() {
        this.owlModel.setWriterSettings(new JenaWriterSettings(this.owlModel));
        this.updateProtegePanel();
    }

    private void setProtegeWriterSettings() {
        this.owlModel.setWriterSettings(new ProtegeWriterSettings(this.owlModel));
        this.updateProtegePanel();
    }

    private void setSortAlphabetically(boolean selected) {
        ProtegeWriterSettings p = (ProtegeWriterSettings)this.owlModel.getWriterSettings();
        p.setSortAlphabetically(selected);
    }

    private void setUseXMLEntities(boolean selected) {
        ProtegeWriterSettings p = (ProtegeWriterSettings)this.owlModel.getWriterSettings();
        p.setUseXMLEntities(selected);
    }

    private void updateProtegePanel() {
        WriterSettings settings = this.owlModel.getWriterSettings();
        boolean enabled = settings instanceof ProtegeWriterSettings;
        if (enabled) {
            ProtegeWriterSettings p = (ProtegeWriterSettings)settings;
            this.sortAlphabeticallyBox.setSelected(p.isSortAlphabetically());
            this.useXMLEntitiesBox.setSelected(p.getUseXMLEntities());
        }
        this.sortAlphabeticallyBox.setEnabled(enabled);
        this.useXMLEntitiesBox.setEnabled(enabled);
    }
}

