/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.properties.OWLAnnotationPropertySubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLDatatypePropertySubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLObjectPropertySubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertyHierarchyPanel;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSubpropertyPane;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSuperpropertiesPanel;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OWLPropertyHierarchiesPanel
extends JPanel
implements Selectable,
HostResourceDisplay {
    private OWLModel owlModel;
    private JTabbedPane tabbedPane;
    private OWLPropertyHierarchyPanel objectPropertyHierarchy;
    private OWLPropertyHierarchyPanel datatypePropertyHierarchy;
    private OWLPropertyHierarchyPanel annotationPropertyHierarchy;
    private OWLPropertyHierarchyPanel allPropertiesHierarchy;
    ArrayList listeners;

    public OWLPropertyHierarchiesPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.listeners = new ArrayList();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.objectPropertyHierarchy = this.createPanel(new OWLObjectPropertySubpropertyPane(this.owlModel), "OWLObjectProperty");
        this.tabbedPane.add("Object", this.objectPropertyHierarchy);
        this.datatypePropertyHierarchy = this.createPanel(new OWLDatatypePropertySubpropertyPane(this.owlModel), "OWLDatatypeProperty");
        this.tabbedPane.add("Datatype", this.datatypePropertyHierarchy);
        this.annotationPropertyHierarchy = this.createPanel(new OWLAnnotationPropertySubpropertyPane(this.owlModel), "OWLDatatypeProperty");
        this.tabbedPane.add("Annotation", this.annotationPropertyHierarchy);
        this.allPropertiesHierarchy = this.createPanel(new OWLSubpropertyPane(this.owlModel), "OWLObjectProperty");
        this.tabbedPane.add("All", this.allPropertiesHierarchy);
        this.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (OWLPropertyHierarchiesPanel.this.isShowing()) {
                    OWLPropertyHierarchiesPanel.this.notifySelectionListeners();
                }
            }
        });
        JLabel label = ComponentFactory.createLabel((Icon)Icons.getProjectIcon());
        label.setText(this.owlModel.getProject().getName());
        String forProjectLabel = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent header = new HeaderComponent("Property Browser", forProjectLabel, (JComponent)label);
        header.setColor(Colors.getSlotColor());
        this.add((Component)header, "North");
    }

    private OWLPropertyHierarchyPanel createPanel(OWLSubpropertyPane subpropertyPane, String iconBase) {
        subpropertyPane.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                OWLPropertyHierarchiesPanel.this.notifySelectionListeners();
            }
        });
        OWLSuperpropertiesPanel superpropertiesPanel = new OWLSuperpropertiesPanel(subpropertyPane, this.owlModel);
        superpropertiesPanel.setAddActionIconBase(iconBase);
        superpropertiesPanel.setRemoveActionIconBase(iconBase);
        return new OWLPropertyHierarchyPanel(subpropertyPane, superpropertiesPanel);
    }

    public Collection getSelection() {
        OWLPropertyHierarchyPanel panel = (OWLPropertyHierarchyPanel)this.tabbedPane.getSelectedComponent();
        if (panel != null) {
            return panel.getSubpropertyPane().getSelection();
        }
        return Collections.EMPTY_LIST;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listeners.add(selectionListener);
    }

    public void clearSelection() {
    }

    public void notifySelectionListeners() {
        for (SelectionListener curListener : new ArrayList(this.listeners)) {
            SelectionEvent event = new SelectionEvent((Selectable)this, 1);
            curListener.selectionChanged(event);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
    }

    public static void main(String[] args) {
        try {
            JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModel();
            owlModel.createOWLObjectProperty("A");
            OWLPropertyHierarchiesPanel panel = new OWLPropertyHierarchiesPanel(owlModel);
            JFrame f = new JFrame();
            f.setSize(300, 700);
            f.setDefaultCloseOperation(3);
            f.setContentPane(panel);
            f.show();
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public boolean displayHostResource(RDFResource resource) {
        boolean result = false;
        if (resource instanceof RDFProperty) {
            RDFProperty property = (RDFProperty)resource;
            OWLPropertyHierarchyPanel panel = this.allPropertiesHierarchy;
            panel = property.isAnnotationProperty() ? this.annotationPropertyHierarchy : (property instanceof OWLObjectProperty ? this.objectPropertyHierarchy : this.datatypePropertyHierarchy);
            this.tabbedPane.setSelectedComponent(panel);
            result = panel.getSubpropertyPane().displayHostResource(property);
        }
        return result;
    }
}

