/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.SlotsTreeDragSourceListener;
import edu.stanford.smi.protege.ui.SlotsTreeTarget;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SuperslotTraverser;
import edu.stanford.smi.protege.util.Traverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OverlayIcon;
import edu.stanford.smi.protegex.owl.ui.matrix.property.PropertyMatrixAction;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertySubpropertyRoot;
import edu.stanford.smi.protegex.owl.ui.properties.actions.CreateSubpropertyAction;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultPropertyFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.subsumption.TooltippedSelectableTree;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OWLSubpropertyPane
extends SelectableContainer
implements HostResourceDisplay {
    private Action createAnnotationOWLDatatypePropertyAction = new AbstractAction("Create annotation datatype property", OWLIcons.getCreatePropertyIcon("AnnotationOWLDatatypeProperty")){

        public void actionPerformed(ActionEvent e) {
            OWLDatatypeProperty property = null;
            try {
                try {
                    OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString());
                    String name = OWLSubpropertyPane.this.owlModel.createNewResourceName("annotationProperty");
                    property = OWLSubpropertyPane.this.owlModel.createAnnotationOWLDatatypeProperty(name);
                }
                catch (Exception ex) {
                    OWLUI.handleError(OWLSubpropertyPane.this.owlModel, ex);
                }
            }
            finally {
                OWLSubpropertyPane.this.owlModel.endTransaction();
            }
            OWLSubpropertyPane.this.displayHostResource(property);
        }
    };
    private Action createAnnotationOWLObjectPropertyAction = new AbstractAction("Create annotation object property", OWLIcons.getCreatePropertyIcon("AnnotationOWLObjectProperty")){

        public void actionPerformed(ActionEvent e) {
            OWLObjectProperty property = null;
            try {
                try {
                    OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString());
                    String name = OWLSubpropertyPane.this.owlModel.createNewResourceName("annotationProperty");
                    property = OWLSubpropertyPane.this.owlModel.createAnnotationOWLObjectProperty(name);
                }
                catch (Exception ex) {
                    OWLUI.handleError(OWLSubpropertyPane.this.owlModel, ex);
                }
            }
            finally {
                OWLSubpropertyPane.this.owlModel.endTransaction();
            }
            OWLSubpropertyPane.this.displayHostResource(property);
        }
    };
    private Action createOWLDatatypePropertyAction = new AbstractAction("Create datatype property", OWLIcons.getCreatePropertyIcon("OWLDatatypeProperty")){

        public void actionPerformed(ActionEvent e) {
            OWLDatatypeProperty property = null;
            try {
                try {
                    OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString());
                    String name = OWLSubpropertyPane.this.owlModel.createNewResourceName("datatypeProperty");
                    property = OWLSubpropertyPane.this.owlModel.createOWLDatatypeProperty(name);
                    property.setDomainDefined(false);
                }
                catch (Exception ex) {
                    OWLUI.handleError(OWLSubpropertyPane.this.owlModel, ex);
                }
            }
            finally {
                OWLSubpropertyPane.this.owlModel.endTransaction();
            }
            OWLSubpropertyPane.this.displayHostResource(property);
        }
    };
    private Action createOWLObjectPropertyAction = new AbstractAction("Create object property", OWLIcons.getCreatePropertyIcon("OWLObjectProperty")){

        public void actionPerformed(ActionEvent e) {
            OWLObjectProperty property = null;
            try {
                try {
                    OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString());
                    String name = OWLSubpropertyPane.this.owlModel.createNewResourceName("objectProperty");
                    property = OWLSubpropertyPane.this.owlModel.createOWLObjectProperty(name);
                    property.setDomainDefined(false);
                }
                catch (Exception ex) {
                    OWLUI.handleError(OWLSubpropertyPane.this.owlModel, ex);
                }
            }
            finally {
                OWLSubpropertyPane.this.owlModel.endTransaction();
            }
            OWLSubpropertyPane.this.displayHostResource(property);
        }
    };
    private Action createRDFPropertyAction = new AbstractAction("Create RDF property", OWLIcons.getCreatePropertyIcon("RDFProperty")){

        public void actionPerformed(ActionEvent e) {
            RDFProperty property = null;
            try {
                try {
                    OWLSubpropertyPane.this.owlModel.beginTransaction(this.getValue("Name").toString());
                    String name = OWLSubpropertyPane.this.owlModel.createNewResourceName("property");
                    property = OWLSubpropertyPane.this.owlModel.createRDFProperty(name);
                }
                catch (Exception ex) {
                    OWLUI.handleError(OWLSubpropertyPane.this.owlModel, ex);
                }
            }
            finally {
                OWLSubpropertyPane.this.owlModel.endTransaction();
            }
            OWLSubpropertyPane.this.displayHostResource(property);
        }
    };
    private Action createSubpropertyAction = new AbstractAction("Create subproperty", OWLIcons.getCreatePropertyIcon("SubProperty")){

        public void actionPerformed(ActionEvent e) {
            Collection sel = OWLSubpropertyPane.this.getSelection();
            if (sel.size() == 1) {
                RDFProperty superProperty = (RDFProperty)sel.iterator().next();
                CreateSubpropertyAction.performAction(OWLSubpropertyPane.this.owlModel, superProperty, OWLSubpropertyPane.this);
            }
        }
    };
    private Action deletePropertyAction = new DeleteAction("Delete properties", (Selectable)this, OWLIcons.getDeleteIcon("RDFProperty")){

        public void onDelete(Collection slots) {
            OWLSubpropertyPane.this.handleDelete(slots);
        }

        public void onSelectionChange() {
            RDFProperty slot = (RDFProperty)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            if (slot != null) {
                this.setAllowed(slot.isEditable());
            }
        }
    };
    private OWLModel owlModel;
    private OWLPropertySubpropertyRoot root;
    private Action viewPropertyAction = new ViewAction("View selected properties", (Selectable)this){

        public void onView(Object o) {
            OWLSubpropertyPane.this.owlModel.getProject().show((Instance)((RDFProperty)o));
        }
    };

    public OWLSubpropertyPane(Project p) {
        this((OWLModel)p.getKnowledgeBase());
    }

    public OWLSubpropertyPane(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.root = this.createRoot();
        TooltippedSelectableTree tree = new TooltippedSelectableTree(this.viewPropertyAction, this.root);
        tree.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer()));
        tree.setShowsRootHandles(true);
        tree.setSelectionRow(0);
        tree.setLargeModel(true);
        this.setSelectable((Selectable)tree);
        this.setLayout(new BorderLayout());
        LabeledComponent labeledComponent = new LabeledComponent(this.getHeaderLabel(), ComponentFactory.createScrollPane((JComponent)((Object)tree)));
        labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)labeledComponent, "Center");
        DefaultPropertyFind findAlg = new DefaultPropertyFind(owlModel, 1){

            protected boolean isValidFrameToSearch(Frame f) {
                return super.isValidFrameToSearch(f) && OWLSubpropertyPane.this.root.isSuitable((RDFProperty)f);
            }
        };
        FindInDialogAction fAction = new FindInDialogAction(findAlg, Icons.getFindSlotIcon(), this, true);
        ResourceFinder finder = new ResourceFinder(fAction);
        this.add(finder, "South");
        finder.addButton(new PropertyMatrixAction(owlModel));
        tree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)tree)){

            public JPopupMenu getPopupMenu() {
                return OWLSubpropertyPane.this.getPopupMenu();
            }
        });
        this.setupDragAndDrop();
        this.viewPropertyAction.setEnabled(true);
        this.deletePropertyAction.setEnabled(true);
        labeledComponent.setHeaderIcon(this.getHeaderIcon());
        WidgetUtilities.addViewButton(labeledComponent, this.viewPropertyAction);
        for (Action curAction : this.getActions()) {
            labeledComponent.addHeaderButton(curAction);
        }
        JButton deleteButton = labeledComponent.addHeaderButton(this.deletePropertyAction);
        deleteButton.setDisabledIcon(((OverlayIcon)deleteButton.getIcon()).getGrayedIcon());
    }

    protected String getHeaderLabel() {
        return "Properties";
    }

    protected Icon getHeaderIcon() {
        return OWLIcons.getImageIcon("Properties");
    }

    protected Action getCreateAnnotationOWLDatatypePropertyAction() {
        return this.createAnnotationOWLDatatypePropertyAction;
    }

    protected Action getCreateAnnotationOWLObjectPropertyAction() {
        return this.createAnnotationOWLObjectPropertyAction;
    }

    protected Action getCreateOWLDatatypePropertyAction() {
        return this.createOWLDatatypePropertyAction;
    }

    protected Action getCreateOWLObjectPropertyAction() {
        return this.createOWLObjectPropertyAction;
    }

    protected Action getCreateRDFPropertyAction() {
        return this.createRDFPropertyAction;
    }

    protected Action getCreateSubpropertyAction() {
        return this.createSubpropertyAction;
    }

    protected Action getDeletePropertyAction() {
        return this.deletePropertyAction;
    }

    public boolean contains(RDFProperty property) {
        TreeNode root = (TreeNode)this.getTree().getModel().getRoot();
        return this.contains(root, property, new HashSet());
    }

    private boolean contains(TreeNode node, RDFProperty property, Set reached) {
        if (!reached.contains(node)) {
            reached.add(node);
            if (node instanceof LazyTreeNode && property.equals(((LazyTreeNode)node).getUserObject())) {
                return true;
            }
            int i = 0;
            while (i < node.getChildCount()) {
                if (this.contains(node.getChildAt(i), property, reached)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Collection getActions() {
        ArrayList<Action> list = new ArrayList<Action>();
        if (ProfilesManager.isFeatureSupported(this.owlModel, OWLProfiles.CreateRDFProperty)) {
            list.add(this.createRDFPropertyAction);
        }
        boolean datatypeSlots = ProfilesManager.isFeatureSupported(this.owlModel, OWLProfiles.Create_DatatypeProperty);
        boolean objectSlots = ProfilesManager.isFeatureSupported(this.owlModel, OWLProfiles.Create_ObjectProperty);
        if (datatypeSlots) {
            list.add(this.createOWLDatatypePropertyAction);
        }
        if (objectSlots) {
            list.add(this.createOWLObjectPropertyAction);
        }
        list.add(this.createSubpropertyAction);
        if (datatypeSlots) {
            list.add(this.createAnnotationOWLDatatypePropertyAction);
        }
        if (objectSlots) {
            list.add(this.createAnnotationOWLObjectPropertyAction);
        }
        return list;
    }

    protected OWLPropertySubpropertyRoot createRoot() {
        return new OWLPropertySubpropertyRoot(this.getOWLModel());
    }

    public void extendSelection(RDFProperty slot) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)slot);
    }

    public RDFProperty getDisplayParent() {
        RDFProperty slot = null;
        TreePath childPath = this.getTree().getSelectionModel().getLeadSelectionPath();
        if (childPath != null) {
            TreePath path = childPath.getParentPath();
            LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            slot = o instanceof RDFProperty ? (RDFProperty)o : null;
        }
        return slot;
    }

    public JComponent getDropComponent() {
        return this.getTree();
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public List getPath(RDFProperty property, List list) {
        list.add(0, property);
        RDFProperty superproperty = (RDFProperty)CollectionUtilities.getFirstItem((Collection)property.getSuperproperties(false));
        if (superproperty != null) {
            this.getPath(superproperty, list);
        }
        return list;
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu menu = null;
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            RDFProperty slot = (RDFProperty)CollectionUtilities.getFirstItem((Collection)selection);
            menu = new JPopupMenu();
            ResourceActionManager.addResourceActions(menu, (Component)((Object)this), (RDFResource)slot);
        }
        return menu;
    }

    public JTree getTree() {
        return (JTree)this.getSelectable();
    }

    protected void handleDelete(Collection properties) {
        this.removeSelection();
        try {
            this.owlModel.beginTransaction("Delete properties " + properties);
            for (RDFProperty property : properties) {
                property.delete();
            }
        }
        finally {
            this.owlModel.endTransaction(true);
        }
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setExpandedProperty(RDFProperty property, boolean expanded) {
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)this.getPath(property, new LinkedList()), (boolean)expanded);
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)renderer);
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.getTree(), 3, (DragGestureListener)new SlotsTreeDragSourceListener());
        new DropTarget(this.getTree(), 3, (DropTargetListener)new SlotsTreeTarget());
    }

    public void setDisplayParent(RDFProperty property) {
        ComponentUtilities.setDisplayParent((JTree)this.getTree(), (Object)property, (Traverser)new SuperslotTraverser());
    }

    public boolean displayHostResource(RDFResource resource) {
        if (!this.getSelection().contains(resource)) {
            ComponentUtilities.setSelectedObjectPath((JTree)this.getTree(), (Collection)this.getPath((RDFProperty)resource, new LinkedList()));
        }
        return true;
    }
}

