/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.actions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;

public class ChangePropertyTypeAction
extends ResourceAction {
    public ChangePropertyTypeAction() {
        super("Change property metaclass...", Icons.getBlankIcon(), "ConvertType");
    }

    public void actionPerformed(ActionEvent e) {
        RDFProperty property;
        RDFProperty slot = property = (RDFProperty)this.getResource();
        Cls rootType = this.getRootType(slot);
        RDFSNamedClass rdfPropertyClass = this.getOWLModel().getRDFPropertyClass();
        boolean rdfPropertyWasVisible = rdfPropertyClass.isVisible();
        rdfPropertyClass.setVisible(true);
        OWLNamedClass owlObjectPropertyClass = this.getOWLModel().getOWLObjectPropertyClass();
        boolean owlObjectPropertyWasVisible = owlObjectPropertyClass.isVisible();
        boolean objectPropertiesAllowed = ProfilesManager.isFeatureSupported(this.getOWLModel(), OWLProfiles.Create_ObjectProperty);
        owlObjectPropertyClass.setVisible(objectPropertiesAllowed);
        OWLNamedClass owlDatatypePropertyClass = this.getOWLModel().getOWLDatatypePropertyClass();
        boolean owlDatatypePropertyWasVisible = owlDatatypePropertyClass.isVisible();
        boolean datatypePropertiesAllowed = ProfilesManager.isFeatureSupported(this.getOWLModel(), OWLProfiles.Create_DatatypeProperty);
        owlDatatypePropertyClass.setVisible(datatypePropertiesAllowed);
        RDFSNamedClass type = ProtegeUI.getSelectionDialogFactory().selectClass(this.getComponent(), this.getOWLModel(), Collections.singleton(rootType), "Select property metaclass");
        rdfPropertyClass.setVisible(rdfPropertyWasVisible);
        owlObjectPropertyClass.setVisible(owlObjectPropertyWasVisible);
        owlDatatypePropertyClass.setVisible(owlDatatypePropertyWasVisible);
        if (type != null && !property.hasRDFType(type)) {
            boolean isDatatype = type.getSuperclasses(true).contains(owlDatatypePropertyClass);
            if (property instanceof OWLObjectProperty && isDatatype) {
                property.setRange(null);
            } else {
                boolean isObject = type.getSuperclasses(true).contains(owlObjectPropertyClass);
                if (property instanceof OWLDatatypeProperty && isObject) {
                    property.setRange(null);
                } else if (!(property instanceof OWLProperty) && (isDatatype || isObject)) {
                    property.setRange(null);
                }
            }
            property.setProtegeType(type);
        }
    }

    private Cls getRootType(Slot slot) {
        OWLModel owlModel = (OWLModel)slot.getKnowledgeBase();
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.RDF) || !(slot instanceof OWLProperty)) {
            return owlModel.getRDFPropertyClass();
        }
        if (slot instanceof OWLDatatypeProperty) {
            return owlModel.getOWLDatatypePropertyClass();
        }
        return owlModel.getOWLObjectPropertyClass();
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        if (resource.isEditable() && resource instanceof RDFProperty) {
            if (resource instanceof OWLProperty) {
                Collection types = Collections.singleton(this.getRootType((Slot)resource));
                return DisplayUtilities.hasMultipleConcreteClses((KnowledgeBase)this.getOWLModel(), (Collection)types);
            }
            return true;
        }
        return false;
    }
}

