/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.search.FindUsage;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableItem;
import java.util.Collection;

public class FindUsageAsDisjointClassTestCase
extends AbstractJenaTestCase {
    public void testFindSimpleDisjointClass() {
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        hostCls.addDisjointClass(otherCls);
        Collection items = FindUsage.getItems(otherCls);
        FindUsageAsDisjointClassTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageAsDisjointClassTestCase.assertEquals((Object)hostCls, (Object)item.host);
        FindUsageAsDisjointClassTestCase.assertEquals((Object)otherCls, (Object)item.usage);
        FindUsageAsDisjointClassTestCase.assertEquals((int)2, (int)item.type);
    }

    public void testFindComplexDisjointClass() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(this.owlModel.createOWLMinCardinality(property, 1));
        unionCls.addOperand(this.owlModel.createOWLComplementClass(otherCls));
        hostCls.addDisjointClass(unionCls);
        Collection items = FindUsage.getItems(otherCls);
        FindUsageAsDisjointClassTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageAsDisjointClassTestCase.assertEquals((Object)hostCls, (Object)item.host);
        FindUsageAsDisjointClassTestCase.assertEquals((Object)unionCls, (Object)item.usage);
        FindUsageAsDisjointClassTestCase.assertEquals((int)2, (int)item.type);
    }
}

