/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class ChangedClassItem
implements Comparable {
    private OWLNamedClass cls;
    private Collection addedSuperClses = new ArrayList();
    private Collection removedSuperClses = new ArrayList();

    ChangedClassItem(OWLNamedClass cls) {
        this.cls = cls;
    }

    void addAddedSuperCls(Cls superCls) {
        this.addedSuperClses.add(superCls);
    }

    void addRemovedSuperCls(Cls superCls) {
        this.removedSuperClses.add(superCls);
    }

    void assertChange() {
        for (RDFSClass superCls : this.addedSuperClses) {
            this.cls.addSuperclass(superCls);
        }
        for (RDFSClass superCls : this.removedSuperClses) {
            this.cls.removeSuperclass(superCls);
        }
        OWLUtil.setConsistentClassificationStatus(this.cls);
    }

    public int compareTo(Object o) {
        ChangedClassItem other = (ChangedClassItem)o;
        return this.cls.compareTo(other.cls);
    }

    OWLNamedClass getCls() {
        return this.cls;
    }

    void removeAddedSuperCls(Cls superCls) {
        this.removedSuperClses.add(superCls);
    }

    public String toString() {
        if (this.cls.getClassificationStatus() == 2) {
            return "Inconsistent";
        }
        if (this.addedSuperClses.size() == 1 && this.removedSuperClses.size() == 1) {
            Cls removedSuperCls = (Cls)this.removedSuperClses.iterator().next();
            Cls addedSuperCls = (Cls)this.addedSuperClses.iterator().next();
            return "Moved from " + removedSuperCls.getBrowserText() + " to " + addedSuperCls.getBrowserText();
        }
        if (this.addedSuperClses.size() > 0 && this.removedSuperClses.size() > 0) {
            return String.valueOf(this.toString("Moved from", this.removedSuperClses.iterator())) + this.toString(" to", this.addedSuperClses.iterator());
        }
        if (this.addedSuperClses.size() > 0) {
            Iterator added = this.addedSuperClses.iterator();
            return this.toString("Added", added);
        }
        Iterator removed = this.removedSuperClses.iterator();
        return this.toString("Removed", removed);
    }

    private String toString(String base, Iterator added) {
        int count = 0;
        String str = "";
        while (added.hasNext()) {
            Cls c = (Cls)added.next();
            str = String.valueOf(str) + c.getBrowserText();
            if (added.hasNext()) {
                str = String.valueOf(str) + ", ";
            }
            ++count;
        }
        return String.valueOf(base) + " " + str;
    }
}

