/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import com.sun.tools.javac.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jena.schemagen;
import org.daml.kazuki.ClassCatalog;
import org.daml.kazuki.Datatypes;
import org.daml.kazuki.JavaUtil;
import org.daml.kazuki.KazukiException;
import org.daml.kazuki.ModelUtil;
import org.daml.kazuki.NonDatatype;
import org.daml.kazuki.VocabularyCatalog;

public class GenerateInterface {
    public String OPT_ROOT_DIR = "interface";
    public String OPT_ROOT_PACKAGE = "interface";
    public String OPT_BASE = "base";
    public String OPT_CUSTOM = "custom";
    public String OPT_IMPL = "";
    public boolean OPT_CUSTOM_P = false;
    public boolean OPT_OVERWRITE_P = false;
    public boolean OPT_DATE_P = false;
    private String OPT_inputFile = null;
    public boolean OPT_GENERATE_VOCABULARY = false;
    public String OPT_VOCAB_DIR = "vocabulary";
    public String OPT_VOCAB_PACKAGE = "vocabulary";
    public String OPT_VOCAB_BIN = null;
    public boolean OPT_LOAD_IMPORTS = true;
    public String INDENT = "    ";
    private final String RESOURCE = "com.hp.hpl.jena.rdf.model.Resource";
    private final String ITERATOR = "com.hp.hpl.jena.util.iterator.ExtendedIterator";
    private final String RDFNODE = "com.hp.hpl.jena.rdf.model.RDFNode";
    private final String JENA_EnhNode = "com.hp.hpl.jena.enhanced.EnhNode";
    private final String JENA_Node = "com.hp.hpl.jena.graph.Node";
    private final String JENA_EnhGraph = "com.hp.hpl.jena.enhanced.EnhGraph";
    private final String JENA_Implementation = "com.hp.hpl.jena.enhanced.Implementation";
    private final String JENA_RDF = "com.hp.hpl.jena.vocabulary.RDF";
    private final String JENA_Profile = "com.hp.hpl.jena.ontology.Profile";
    private final String JENA_OntModel = "com.hp.hpl.jena.ontology.OntModel";
    private final String JENA_Ontology = "com.hp.hpl.jena.ontology.Ontology";
    private final String JENA_OntResource = "com.hp.hpl.jena.ontology.OntResource";
    private final String JENA_OntDocumentManager = "com.hp.hpl.jena.ontology.OntDocumentManager";
    private final String JENA_ConversionException = "com.hp.hpl.jena.ontology.ConversionException";
    private final String JENA_Individual = "com.hp.hpl.jena.ontology.Individual";
    private final String JENA_IndividualImpl = "com.hp.hpl.jena.ontology.impl.IndividualImpl";
    private final String JENA_WrappedIterator = "com.hp.hpl.jena.util.iterator.WrappedIterator";
    private final String JENA_Map1 = "com.hp.hpl.jena.util.iterator.Map1";
    private final String JENA_RDFNode = "com.hp.hpl.jena.rdf.model.RDFNode";
    private final String JENA_Resource = "com.hp.hpl.jena.rdf.model.Resource";
    private final String JENA_Statement = "com.hp.hpl.jena.rdf.model.Statement";
    private final String JENA_Literal = "com.hp.hpl.jena.rdf.model.Literal";
    private final String JENA_RDFDatatype = "com.hp.hpl.jena.datatypes.RDFDatatype";
    private final String JENA_TypeMapper = "com.hp.hpl.jena.datatypes.TypeMapper";
    private final String JENA_LiteralRequiredException = "com.hp.hpl.jena.rdf.model.LiteralRequiredException";
    private final String JENA_XSDDatatype = "com.hp.hpl.jena.datatypes.xsd.XSDDatatype";
    private final String KAZ_ModelUtil = "org.daml.kazuki.ModelUtil";
    private final String KAZ_NullFilter = "org.daml.kazuki.ModelUtil.nullFilter";
    private final String KAZ_ResourceMapper = "org.daml.kazuki.ModelUtil.objectAsResourceMapper";
    private final String KAZ_createTypedLiteral = "org.daml.kazuki.Datatypes.createTypedLiteral";
    private File rootDir;
    private File baseDir;
    private File customDir;
    private String basePackage;
    private String customPackage;
    private ClassCatalog classCatalog = null;
    private VocabularyCatalog vocabCatalog;
    private boolean verbose = true;
    private Hashtable propertyHT = new Hashtable();
    private static final int NO_TYPE = 0;
    private static final int PRIMITIVE_TYPE = 1;
    private static final int JAVA_TYPE = 2;
    private static final int CUSTOM_TYPE = 3;
    private static final int CLASS_TYPE = 4;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DatatypeProperty;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AllValuesFromRestriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DataRange;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;

    public static void main(String[] stringArray) {
        GenerateInterface generateInterface = new GenerateInterface();
        if (!GenerateInterface.parseArguments(stringArray, generateInterface)) {
            GenerateInterface.usage();
            return;
        }
        generateInterface.generateInterface(generateInterface.OPT_inputFile);
    }

    private static void usage() {
        GenerateInterface generateInterface = new GenerateInterface();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("GenerateModel [options] inputFile");
        System.out.println();
        System.out.println("options:");
        System.out.println();
        System.out.println(" -HELP");
        System.out.println("\tPrints this message.");
        System.out.println(" -ROOTDIR <directory>");
        System.out.println("\tThe base directory where the files are written.");
        System.out.println("\tThe default value is " + generateInterface.OPT_ROOT_DIR + ".");
        System.out.println(" -ROOT <package>");
        System.out.println("\tThe base package in which the files are generated.");
        System.out.println("\tThe default value is " + generateInterface.OPT_ROOT_PACKAGE + ".");
        System.out.println(" -BASE <base>");
        System.out.println("\tThe name to use for the Implementation package/folder.");
        System.out.println("\tThe default value is " + generateInterface.OPT_BASE + ".");
        System.out.println(" -CUSTOM <custom>");
        System.out.println("\tThe name to use for the Custom package/folder.");
        System.out.println("\tThe default value is " + generateInterface.OPT_CUSTOM + ".");
        System.out.println(" -GEN_CUSTOM");
        System.out.println("\tWhen specified will generate a set of Class files that");
        System.out.println("\tcan be customized by the developer.  If the file already");
        System.out.println("\texists the new file will be created with a .NEW extension.");
        System.out.println("\tThe default value is " + generateInterface.OPT_CUSTOM_P + ".");
        System.out.println(" -OVERWRITE");
        System.out.println("\tWhen -GEN_CUSTOM is also specified it will replace any existing");
        System.out.println("\tcustom files.  The original file will be renamed with a .BAK extension.");
        System.out.println("\tThe default value is " + generateInterface.OPT_OVERWRITE_P + ".");
        System.out.println(" -DATE");
        System.out.println("\tWhen specified will add a creation date in the file comments.");
        System.out.println("\tThe default value is " + generateInterface.OPT_DATE_P + ".");
        System.out.println(" -GEN_VOCAB");
        System.out.println("\tWhen specified, the vocabulary files are also generated.");
        System.out.println("\tRequires a value for VOCAB_DIR and VOCAB_PACKAGE.  The");
        System.out.println("\tfiles are compiled before the kazuki interface files are");
        System.out.println("\tcreated, so <JAVAHOME>/lib/tools.jar and VOCAB_BIN must be");
        System.out.println("\tin the classpath to use this option.");
        System.out.println("\tThe default value is " + generateInterface.OPT_GENERATE_VOCABULARY + ".");
        System.out.println(" -VOCAB_DIR <directory>");
        System.out.println("\tThe directory to place generated vocabulary files.");
        System.out.println("\tThe default value is " + generateInterface.OPT_VOCAB_DIR + ".");
        System.out.println(" -VOCAB_PACKAGE <package>");
        System.out.println("\tThe package to use for generated vocabulary files.");
        System.out.println("\tThe default value is " + generateInterface.OPT_VOCAB_PACKAGE + ".");
        System.out.println(" -VOCAB_BIN <directory>");
        System.out.println("\tWhere to place the compiled vocabulary files.");
        System.out.println("\tDefaults to the value of VOCAB_DIR.");
        System.out.println("\tThe default value is " + generateInterface.OPT_VOCAB_BIN + ".");
        System.out.println(" -NO_IMPORTS");
        System.out.println("\tWhen specified, vocabularies and kazuki classes not will be");
        System.out.println("\tgenerated for imported ontologies.");
        System.out.println("\tThe default value is " + generateInterface.OPT_LOAD_IMPORTS + ".");
        System.out.println();
        System.out.println(" inputFile");
        System.out.println("\tAn input file which enumerates the ontology files to load and vocabulary packages.");
        System.out.println("\tEach line of the file is either <URL> or <FILENAME> <BASEURI> or v <VOCAB_PACKAGE>");
        System.out.println();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean parseArguments(String[] stringArray, GenerateInterface generateInterface) {
        boolean bl = stringArray.length > 0;
        int n = 0;
        try {
            while (bl) {
                if (n >= stringArray.length) {
                    return bl;
                }
                if (stringArray[n].equals("-HELP")) {
                    bl = false;
                } else if (stringArray[n].equals("-INPUT")) {
                    generateInterface.OPT_inputFile = stringArray[++n];
                } else if (stringArray[n].equals("-ROOT")) {
                    generateInterface.OPT_ROOT_PACKAGE = stringArray[++n];
                } else if (stringArray[n].equals("-ROOTDIR")) {
                    generateInterface.OPT_ROOT_DIR = stringArray[++n];
                } else if (stringArray[n].equals("-DATE")) {
                    generateInterface.OPT_DATE_P = true;
                } else if (stringArray[n].equals("-GEN_CUSTOM")) {
                    generateInterface.OPT_CUSTOM_P = true;
                } else if (stringArray[n].equals("-CUSTOM")) {
                    generateInterface.OPT_CUSTOM = stringArray[++n];
                } else if (stringArray[n].equals("-OVERWRITE")) {
                    generateInterface.OPT_OVERWRITE_P = true;
                } else if (stringArray[n].equals("-BASE")) {
                    generateInterface.OPT_BASE = stringArray[++n];
                } else if (stringArray[n].equals("-GEN_VOCAB")) {
                    generateInterface.OPT_GENERATE_VOCABULARY = true;
                } else if (stringArray[n].equals("-VOCAB_DIR")) {
                    generateInterface.OPT_VOCAB_DIR = stringArray[++n];
                } else if (stringArray[n].equals("-VOCAB_PACKAGE")) {
                    generateInterface.OPT_VOCAB_PACKAGE = stringArray[++n];
                } else if (stringArray[n].equals("-VOCAB_BIN")) {
                    generateInterface.OPT_VOCAB_BIN = stringArray[++n];
                } else if (stringArray[n].equals("-NO_IMPORTS")) {
                    generateInterface.OPT_LOAD_IMPORTS = false;
                } else if (generateInterface.OPT_inputFile == null && !stringArray[n].startsWith("-")) {
                    generateInterface.OPT_inputFile = stringArray[n];
                } else {
                    bl = false;
                }
                ++n;
            }
            return bl;
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            return false;
        }
    }

    public void generateInterface(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        try {
            this.parseInputFile(string, arrayList, arrayList2, arrayList3);
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while parsing the input file:");
            iOException.printStackTrace();
            return;
        }
        Datatypes datatypes = new Datatypes();
        VocabularyCatalog vocabularyCatalog = new VocabularyCatalog();
        try {
            this.parseVocabularies(vocabularyCatalog, arrayList3);
            this.generateInterface(arrayList, arrayList2, vocabularyCatalog, datatypes);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return;
        }
        catch (KazukiException kazukiException) {
            System.err.println(kazukiException.getMessage());
            kazukiException.printStackTrace();
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
    }

    public void parseInputFile(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        boolean bl = false;
        int n = 0;
        while (!bl) {
            String string2 = bufferedReader.readLine();
            ++n;
            if (string2 == null) {
                bl = true;
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("v") && stringTokenizer.hasMoreTokens()) {
                arrayList3.add(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) continue;
                System.err.println("Input file format is incorrect at line " + n);
                continue;
            }
            arrayList.add(string3);
            if (stringTokenizer.hasMoreTokens()) {
                arrayList2.add(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) continue;
                System.err.println("Input file format is incorrect at line " + n);
                continue;
            }
            arrayList2.add(null);
        }
    }

    public void generateVocabularyFiles(ArrayList arrayList, ArrayList arrayList2, VocabularyCatalog vocabularyCatalog) throws KazukiException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Object> arrayList3;
        boolean bl = true;
        if (arrayList.size() == arrayList2.size()) {
            File file;
            arrayList3 = new ArrayList<Object>();
            if (!this.OPT_VOCAB_DIR.endsWith("/")) {
                this.OPT_VOCAB_DIR = this.OPT_VOCAB_DIR + "/";
            }
            if (!(file = new File(this.OPT_VOCAB_DIR)).exists()) {
                System.out.println("making directory " + file.toString());
                System.out.println(file.mkdirs());
            }
            String string = file.getAbsolutePath() + File.separator;
            Iterator iterator = arrayList.iterator();
            Iterator iterator2 = arrayList2.iterator();
            while (iterator.hasNext()) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                String string2 = (String)iterator.next();
                String string3 = (String)iterator2.next();
                if (string3 != null && vocabularyCatalog.getVocabTerm(string3) == null || string3 == null && string2 != null && vocabularyCatalog.getVocabTerm(string2 + "#") == null) {
                    int n;
                    Object object;
                    System.out.println("Doing " + string2 + " " + string3);
                    String string4 = null;
                    if (string3 == null) {
                        string4 = this.extractNameFromURI(string2);
                    } else {
                        string4 = this.extractNameFromURI(string3);
                        arrayList4.add("-a");
                        arrayList4.add(string3);
                    }
                    arrayList4.add("-n");
                    arrayList4.add(string4);
                    arrayList4.add("-i");
                    arrayList4.add(string2);
                    arrayList4.add("-o");
                    arrayList4.add(this.OPT_VOCAB_DIR);
                    arrayList4.add("--package");
                    arrayList4.add(this.OPT_VOCAB_PACKAGE);
                    arrayList4.add("--ontology");
                    arrayList4.add("--owl");
                    if (bl) {
                        System.out.print("schemagen arguments: ");
                        object = arrayList4.iterator();
                        while (object.hasNext()) {
                            System.out.print((String)object.next() + " ");
                        }
                        System.out.println();
                    }
                    schemagen.main((String[])arrayList4.toArray(new String[0]));
                    object = JavaUtil.makePackage(this.OPT_VOCAB_PACKAGE, string4);
                    arrayList3.add(object);
                    if (this.verbose) {
                        System.out.println("Generated vocabulary " + (String)object);
                    }
                    ArrayList<String> arrayList5 = new ArrayList<String>();
                    if (this.OPT_VOCAB_BIN != null) {
                        arrayList5.add("-d");
                        arrayList5.add(this.OPT_VOCAB_BIN);
                    }
                    arrayList5.add("-classpath");
                    arrayList5.add(System.getProperty("java.class.path"));
                    arrayList5.add(this.OPT_VOCAB_DIR + string4 + ".java");
                    if (bl) {
                        System.out.print("javac arguments: ");
                        Iterator iterator3 = arrayList5.iterator();
                        while (iterator3.hasNext()) {
                            System.out.print((String)iterator3.next() + " ");
                        }
                        System.out.println();
                    }
                    if ((n = Main.compile(arrayList5.toArray(new String[0]))) == 0) {
                        System.out.println("Compiled " + (String)object);
                        continue;
                    }
                    System.err.println("Javac status " + n + ": Problem compiling " + (String)object);
                    continue;
                }
                System.out.println("Already loaded " + string2 + " " + string3);
            }
        } else {
            throw new KazukiException("URI list and Base URI list must be of equal sizes.");
        }
        OntDocumentManager.getInstance().setProcessImports(this.OPT_LOAD_IMPORTS);
        this.parseVocabularies(vocabularyCatalog, arrayList3);
    }

    private String extractNameFromURI(String string) throws KazukiException {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1 || n2 < n) {
            return JavaUtil.makeJavaValidName(string.substring(n + 1));
        }
        if (n < n2) {
            return JavaUtil.makeJavaValidName(string.substring(n + 1, n2));
        }
        throw new KazukiException("Unexpected URI: [" + n + "," + n2 + "] " + string);
    }

    public void generateInterface(ArrayList arrayList, ArrayList arrayList2, VocabularyCatalog vocabularyCatalog, Datatypes datatypes) throws FileNotFoundException, KazukiException, IllegalArgumentException, IllegalAccessException {
        OntDocumentManager.getInstance().setProcessImports(this.OPT_LOAD_IMPORTS);
        OntModel ontModel = ModelFactory.createOntologyModel();
        this.loadModel(ontModel, arrayList, arrayList2);
        if (this.OPT_GENERATE_VOCABULARY) {
            this.generateVocabularyFiles(arrayList, arrayList2, vocabularyCatalog);
        }
        this.generateInterface(ontModel, vocabularyCatalog, new ClassCatalog(), datatypes);
    }

    public void generateVocabularyFiles(OntModel ontModel, VocabularyCatalog vocabularyCatalog) throws IllegalArgumentException, KazukiException, IllegalAccessException {
        ArrayList arrayList = this.listOntologyURIs(ontModel);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        int n = 0;
        while (n < arrayList.size()) {
            arrayList2.add(null);
            ++n;
        }
        this.generateVocabularyFiles(arrayList, arrayList2, vocabularyCatalog);
    }

    public void parseVocabularies(VocabularyCatalog vocabularyCatalog, ArrayList arrayList) throws IllegalArgumentException, IllegalAccessException {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    vocabularyCatalog.parseVocabulary(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Unable to find vocabulary class " + string);
                }
            }
        }
    }

    public void loadModel(OntModel ontModel, ArrayList arrayList, ArrayList arrayList2) throws KazukiException, FileNotFoundException {
        if (arrayList2.size() != arrayList.size()) {
            throw new KazukiException("URI list and Base URI list must be of equal sizes.");
        }
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)iterator2.next();
            if (string2 == null) {
                ontModel.read(string);
                continue;
            }
            System.err.println(string + " " + string2);
            FileInputStream fileInputStream = new FileInputStream(string);
            ontModel.read((InputStream)fileInputStream, string2);
        }
    }

    private void setupVariables(Model model, VocabularyCatalog vocabularyCatalog, ClassCatalog classCatalog) {
        this.rootDir = new File(this.OPT_ROOT_DIR);
        this.baseDir = new File(this.rootDir, this.OPT_BASE);
        this.customDir = new File(this.rootDir, this.OPT_CUSTOM);
        this.basePackage = JavaUtil.makePackage(this.OPT_ROOT_PACKAGE, this.OPT_BASE);
        this.customPackage = JavaUtil.makePackage(this.OPT_ROOT_PACKAGE, this.OPT_CUSTOM);
        if (!this.rootDir.exists()) {
            this.rootDir.mkdirs();
        }
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
        if (this.OPT_CUSTOM_P && !this.customDir.exists()) {
            this.customDir.mkdirs();
        }
        this.classCatalog = classCatalog;
        this.vocabCatalog = vocabularyCatalog;
    }

    public ArrayList listOntologyURIs(OntModel ontModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ExtendedIterator extendedIterator = ontModel.listOntologies();
        while (extendedIterator.hasNext()) {
            Ontology ontology = (Ontology)extendedIterator.next();
            String string = ontology.getURI();
            arrayList.add(string);
        }
        extendedIterator.close();
        return arrayList;
    }

    public void generateInterface(OntModel ontModel, VocabularyCatalog vocabularyCatalog, ClassCatalog classCatalog, Datatypes datatypes) throws FileNotFoundException, IllegalArgumentException, KazukiException, IllegalAccessException {
        Resource resource;
        if (this.OPT_GENERATE_VOCABULARY) {
            this.generateVocabularyFiles(ontModel, vocabularyCatalog);
        }
        this.setupVariables((Model)ontModel, vocabularyCatalog, classCatalog);
        Iterator iterator = this.makeResourceSet(ontModel, (ClassFilter)new JavaModelClassFilter()).iterator();
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            if (resource != null && resource.canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass)) {
                String string = this.basePackage;
                if (this.OPT_CUSTOM_P) {
                    string = this.customPackage;
                }
                classCatalog.generateAndAddClass((OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass), string);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("skipping " + resource.toString());
        }
        iterator = this.makeResourceSet(ontModel, (ClassFilter)new JavaModelClassFilter()).iterator();
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            if (resource != null && resource.canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass)) {
                ontModel.reset();
                this.generateClassFiles((OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass), datatypes);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("skipping " + resource.toString());
        }
        this.generateRegistrar(classCatalog, vocabularyCatalog, ontModel);
    }

    private void generateRegistrar(ClassCatalog classCatalog, VocabularyCatalog vocabularyCatalog, OntModel ontModel) throws FileNotFoundException, IllegalAccessException {
        File file = new File(this.baseDir, "Registrar.java");
        PrintWriter printWriter = this.openOutputFile(file, true);
        printWriter.println("/*");
        printWriter.println(" * " + file.getName());
        if (this.OPT_DATE_P) {
            printWriter.println(" *");
            printWriter.println(" * Created on " + new Date());
        }
        printWriter.println(" */");
        printWriter.println();
        if (this.basePackage.length() > 0) {
            printWriter.println("package " + this.basePackage + ";");
            printWriter.println();
        }
        printWriter.println("/*");
        printWriter.println(" *");
        printWriter.println(" * @author Autogenerated");
        printWriter.println(" */");
        printWriter.println("public class Registrar {");
        printWriter.println();
        this.generateRegistrar(classCatalog, printWriter, this.INDENT);
        this.generateImportRegistrar(ontModel, vocabularyCatalog, printWriter, this.INDENT);
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    private void generateImportRegistrar(OntModel ontModel, VocabularyCatalog vocabularyCatalog, PrintWriter printWriter, String string) {
        String string2 = string + this.INDENT;
        printWriter.println();
        printWriter.println(this.INDENT + "/**");
        printWriter.println(this.INDENT + " * Adds imports statements to an ontology and adds imported subModels to a model.");
        printWriter.println(this.INDENT + " */");
        printWriter.println(this.INDENT + "public static void registerImports(" + "com.hp.hpl.jena.ontology.OntModel" + " m, " + "com.hp.hpl.jena.ontology.Ontology" + " ont) {");
        printWriter.println();
        printWriter.println(string2 + "com.hp.hpl.jena.ontology.OntDocumentManager" + " odm = " + "com.hp.hpl.jena.ontology.OntDocumentManager" + ".getInstance();");
        ExtendedIterator extendedIterator = ontModel.listOntologies();
        while (extendedIterator.hasNext()) {
            Ontology ontology = (Ontology)extendedIterator.next();
            String string3 = ontology.getURI();
            String string4 = vocabularyCatalog.getVocabTerm(string3 + "#");
            if (string4 != null) {
                printWriter.println(string2 + "odm.loadImport(m, \"" + ontology.getURI() + "\");");
                printWriter.println(string2 + "ont.addImport(" + string4 + ");");
                continue;
            }
            System.err.println("WARNING: Could not find Vocabulary term for " + string3 + ".");
            System.err.println("  Skipping Imports Register entry.");
            vocabularyCatalog.print();
            printWriter.println(string2 + "// Skipping " + string3 + " - not vocabulary term");
        }
        extendedIterator.close();
        printWriter.println(this.INDENT + "}");
        printWriter.println();
    }

    private void generateRegistrar(ClassCatalog classCatalog, PrintWriter printWriter, String string) {
        String string2 = string + this.INDENT;
        printWriter.println();
        printWriter.println(this.INDENT + "/**");
        printWriter.println(this.INDENT + " * Registers all custom classes with JENA.");
        printWriter.println(this.INDENT + " */");
        printWriter.println(this.INDENT + "public static void registerAll() {");
        printWriter.println();
        Iterator iterator = classCatalog.keys();
        while (iterator.hasNext()) {
            if (this.OPT_CUSTOM_P) {
                printWriter.println(string2 + this.customPackage.toString() + "." + classCatalog.getKazukiClassName((OntClass)iterator.next()) + ".register();");
                continue;
            }
            printWriter.println(string2 + this.basePackage.toString() + "." + classCatalog.getKazukiClassName((OntClass)iterator.next()) + ".register();");
        }
        printWriter.println(this.INDENT + "}");
        printWriter.println();
    }

    private void generateClassFiles(OntClass ontClass, Datatypes datatypes) throws FileNotFoundException, IllegalAccessException {
        String string;
        boolean bl = false;
        if (this.verbose) {
            System.out.println("\nCLASS " + ontClass.getURI());
        }
        if ((string = this.classCatalog.getKazukiClassName(ontClass)) != null) {
            if (this.verbose) {
                System.out.println("--> " + string);
            }
            this.propertyHT.clear();
            File file = new File(this.baseDir, string + ".java");
            File file2 = new File(this.customDir, string + ".java");
            this.generateBase(ontClass, string, datatypes, file);
            if (this.OPT_CUSTOM_P) {
                this.generateCustom(ontClass, string, file2);
            }
        }
    }

    private void generateBase(OntClass ontClass, String string, Datatypes datatypes, File file) throws FileNotFoundException, IllegalAccessException {
        PrintWriter printWriter = this.openOutputFile(file, true);
        printWriter.println("/*");
        printWriter.println(" * " + file.getName());
        if (this.OPT_DATE_P) {
            printWriter.println(" *");
            printWriter.println(" * Created on " + new Date());
        }
        printWriter.println(" */");
        printWriter.println();
        if (this.basePackage.length() > 0) {
            printWriter.println("package " + this.basePackage + ";");
            printWriter.println();
        }
        printWriter.println("/*");
        printWriter.println(" *");
        printWriter.println(" * @author Autogenerated");
        printWriter.println(" */");
        printWriter.println("public class " + string);
        printWriter.println(this.INDENT + "extends " + "com.hp.hpl.jena.ontology.impl.IndividualImpl");
        printWriter.println();
        printWriter.println("{");
        this.generateFactory(this.INDENT, ontClass, printWriter);
        this.generateRegister(this.INDENT, ontClass, printWriter, false);
        this.generateObjectMapper(this.INDENT, ontClass, printWriter);
        this.generateConstructor(this.INDENT, ontClass, printWriter);
        if (!this.OPT_CUSTOM_P) {
            this.generateCreateMethods(this.INDENT, ontClass, printWriter);
        }
        this.generateConstantMethods(this.INDENT, ontClass, printWriter);
        this.generateImplPropertyMethods(this.INDENT, ontClass, datatypes, printWriter);
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
    }

    private void generateRegister(String string, OntClass ontClass, PrintWriter printWriter, boolean bl) {
        String string2 = string + this.INDENT;
        String string3 = string2 + this.INDENT;
        String string4 = string3 + this.INDENT;
        String string5 = this.classCatalog.getKazukiClassName(ontClass);
        printWriter.println();
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println(string + "// Registration method for " + string5);
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println();
        printWriter.println();
        printWriter.println(string + "/**");
        printWriter.println(string + " * Method for registering this class");
        printWriter.println(string + " */");
        printWriter.println(string + "public static void register() {");
        printWriter.println();
        printWriter.println(string2 + "com.hp.hpl.jena.enhanced.BuiltinPersonalities.model.add(" + string5 + ".class, " + string5 + ".factory);");
        if (bl) {
            printWriter.println(string2 + "com.hp.hpl.jena.enhanced.BuiltinPersonalities.model.add(" + this.basePackage.toString() + "." + string5 + ".class, " + string5 + ".factory);");
        }
        printWriter.println(string + "}");
    }

    private void generateFactory(String string, OntClass ontClass, PrintWriter printWriter) {
        String string2 = string + this.INDENT;
        String string3 = string2 + this.INDENT;
        String string4 = string3 + this.INDENT;
        String string5 = this.classCatalog.getKazukiClassName(ontClass);
        String string6 = this.vocabCatalog.getVocabTerm((Resource)ontClass);
        printWriter.println();
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println(string + "// Polymorphism Factory for " + string5);
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println();
        if (string6 == null) {
            System.err.println("WARNING: Could not find vocabulary term for " + ontClass.getURI());
            System.err.println("   Skipping Polymorphism Factory");
            printWriter.println(string + "// Skipping - no vocabulary term found ");
            return;
        }
        printWriter.println();
        printWriter.println(string + "static final public " + "com.hp.hpl.jena.enhanced.Implementation" + " factory = new " + "com.hp.hpl.jena.enhanced.Implementation" + "() {");
        printWriter.println();
        printWriter.println(string2 + "/**");
        printWriter.println(string2 + " * Convert a _node_ into an instance of this class.");
        printWriter.println(string2 + " */");
        printWriter.println(string2 + "public " + "com.hp.hpl.jena.enhanced.EnhNode" + " wrap(" + "com.hp.hpl.jena.graph.Node" + " n, " + "com.hp.hpl.jena.enhanced.EnhGraph" + " eg) {");
        printWriter.println(string3 + "if (canWrap(n, eg)) {");
        printWriter.println(string4 + "return new " + string5 + "(n, eg);");
        printWriter.println(string3 + "} else {");
        printWriter.println(string4 + "throw new " + "com.hp.hpl.jena.ontology.ConversionException" + "(\"Cannot convert node \" + n.toString() + \" to " + string5 + ".\");");
        printWriter.println(string3 + "}");
        printWriter.println(string2 + "}");
        printWriter.println();
        printWriter.println(string2 + "/**");
        printWriter.println(string2 + " * Answer true iff the node <code>n</code> can become an instance of this class,");
        printWriter.println(string2 + " * ie it has type " + string5 + ".");
        printWriter.println(string2 + " */");
        printWriter.println(string2 + "public boolean canWrap(" + "com.hp.hpl.jena.graph.Node" + " n, " + "com.hp.hpl.jena.enhanced.EnhGraph" + " eg) {");
        printWriter.println(string3 + "com.hp.hpl.jena.ontology.Profile" + " profile = (eg instanceof " + "com.hp.hpl.jena.ontology.OntModel" + ") ? ((" + "com.hp.hpl.jena.ontology.OntModel" + ")eg).getProfile() : null;");
        printWriter.println(string3 + "return (profile != null)");
        printWriter.println(string4 + "&& profile.isSupported(n, eg, " + "com.hp.hpl.jena.ontology.Individual" + ".class)");
        printWriter.println(string4 + "&& eg.asGraph().contains(n, " + "com.hp.hpl.jena.vocabulary.RDF" + ".type.asNode(), " + string6 + ".asNode());");
        printWriter.println(string2 + "}");
        printWriter.println();
        printWriter.println(string + "};");
        printWriter.println();
    }

    private void generateObjectMapper(String string, OntClass ontClass, PrintWriter printWriter) {
        String string2 = string + this.INDENT;
        String string3 = string2 + this.INDENT;
        String string4 = string3 + this.INDENT;
        String string5 = string4 + this.INDENT;
        String string6 = this.classCatalog.getKazukiClassName(ontClass);
        printWriter.println();
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println(string + "// Object Mapper for " + string6);
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println();
        printWriter.println();
        printWriter.println(string + "public static " + "com.hp.hpl.jena.util.iterator.Map1" + " objectMapper = new ObjectMapper();");
        printWriter.println();
        printWriter.println();
        printWriter.println(string + "protected static class ObjectMapper implements " + "com.hp.hpl.jena.util.iterator.Map1" + " {");
        printWriter.println(string2 + "public Object map1(Object x) {");
        printWriter.println(string3 + "if (x instanceof " + "com.hp.hpl.jena.rdf.model.Statement" + ") {");
        printWriter.println(string4 + "com.hp.hpl.jena.rdf.model.Resource" + " r = ((" + "com.hp.hpl.jena.rdf.model.Statement" + ")x).getResource();");
        printWriter.println(string4 + "if (r.canAs(" + string6 + ".class))");
        printWriter.println(string5 + "return r.as(" + string6 + ".class);");
        printWriter.println(string3 + "} else if (x instanceof " + "com.hp.hpl.jena.rdf.model.RDFNode" + ") {");
        printWriter.println(string4 + "if (((" + "com.hp.hpl.jena.rdf.model.RDFNode" + ")x).canAs(" + string6 + ".class))");
        printWriter.println(string5 + "return ((" + "com.hp.hpl.jena.rdf.model.RDFNode" + ")x).as(" + string6 + ".class);");
        printWriter.println(string3 + "}");
        printWriter.println(string3 + "return null;");
        printWriter.println(string2 + "}");
        printWriter.println(string + "}");
        printWriter.println();
    }

    private void generateConstructor(String string, OntClass ontClass, PrintWriter printWriter) {
        String string2 = this.classCatalog.getKazukiClassName(ontClass);
        printWriter.println();
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println(string + "// Constructor for " + string2);
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println();
        printWriter.println(string + "/**");
        printWriter.println(string + " * @param n");
        printWriter.println(string + " * @param g");
        printWriter.println(string + " */");
        printWriter.println(string + "public " + string2 + "(" + "com.hp.hpl.jena.graph.Node" + " n, " + "com.hp.hpl.jena.enhanced.EnhGraph" + " g) {");
        printWriter.println(string + this.INDENT + "    super(n, g);");
        printWriter.println();
        printWriter.println(string + "}");
        printWriter.println();
    }

    private void generateCreateMethods(String string, OntClass ontClass, PrintWriter printWriter) {
        String string2 = this.classCatalog.getKazukiClassName(ontClass);
        String string3 = this.vocabCatalog.getVocabTerm((Resource)ontClass);
        if (string3 == null) {
            System.err.println("WARNING: Could not find vocabulary term for " + ontClass.getURI());
            System.err.println("   Skipping create methods");
            printWriter.println(string + "// Skipping convert and create methods - no vocabulary term found");
            return;
        }
        String string4 = string + this.INDENT;
        String string5 = string4 + this.INDENT;
        printWriter.println();
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println(string + "// convert method for " + string2);
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println();
        printWriter.println(string + "public static " + string2 + " convert(" + "com.hp.hpl.jena.ontology.OntResource" + " resource) {");
        printWriter.println(string4 + "if (!resource.hasRDFType(" + string3 + ")) {");
        printWriter.println(string5 + "resource.addRDFType(" + string3 + ");");
        printWriter.println(string4 + "}");
        printWriter.println(string4 + "return (" + string2 + ")resource.as(" + string2 + ".class);");
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println();
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println(string + "// create method for " + string2);
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println();
        printWriter.println(string + "public static " + string2 + " create(String uri, " + "com.hp.hpl.jena.ontology.OntModel" + " model) {");
        printWriter.println(string4 + "return (" + string2 + ")model.createOntResource(" + string2 + ".class, " + string3 + ", uri);");
        printWriter.println(string + "}");
        printWriter.println();
    }

    private void generateConstantMethods(String string, OntClass ontClass, PrintWriter printWriter) {
        Resource resource;
        Statement statement;
        if (ontClass.hasProperty(OWL.oneOf) && (statement = ontClass.getProperty(OWL.oneOf)) != null && (resource = statement.getResource()) != null && resource.canAs(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = GenerateInterface.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList)) {
            HashSet<Resource> hashSet = new HashSet<Resource>();
            ExtendedIterator extendedIterator = ((RDFList)resource.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = GenerateInterface.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList)).iterator();
            while (extendedIterator.hasNext()) {
                Resource resource2 = (Resource)extendedIterator.next();
                hashSet.add(resource2);
            }
            extendedIterator.close();
            this.generateConstantMethods(string, hashSet, this.classCatalog.getKazukiClassName(ontClass), printWriter);
        }
    }

    private void generateConstantMethods(String string, Set set, String string2, PrintWriter printWriter) {
        Object object;
        Resource[] resourceArray = new Resource[set.size()];
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3;
            object = (Resource)iterator.next();
            String string4 = string3 = object.getLocalName();
            try {
                if (object.hasProperty(RDFS.label)) {
                    string4 = object.getProperty(RDFS.label).getString();
                }
            }
            catch (RDFException rDFException) {
                // empty catch block
            }
            resourceArray[n] = object;
            stringArray[n] = string4;
            ++n;
        }
        object = (this.OPT_CUSTOM_P ? this.customPackage.toString() : this.basePackage.toString()) + "." + string2;
        printWriter.println();
        printWriter.println();
        printWriter.println(this.INDENT + "////////////////////////////////////////////////////////////////");
        printWriter.println(this.INDENT + "// Mappings between resources and constant values");
        printWriter.println(this.INDENT + "////////////////////////////////////////////////////////////////");
        printWriter.println();
        printWriter.println(string + "protected static String[] CONST_STRINGS = {");
        int n2 = 0;
        while (n2 < stringArray.length) {
            printWriter.print(string + string + "\"" + stringArray[n2] + "\"");
            if (n2 + 1 < stringArray.length) {
                printWriter.println(",");
            } else {
                printWriter.println("");
            }
            ++n2;
        }
        printWriter.println(string + string + "};");
        printWriter.println();
        printWriter.println(string + "protected static " + "com.hp.hpl.jena.rdf.model.Resource" + "[] CONST_RESOURCES = {");
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string5 = this.vocabCatalog.getVocabTerm(resourceArray[n3]);
            if (string5 == null) {
                System.err.println("WARNING: Could not find vocabulary term for " + resourceArray[n3].getURI());
                System.err.println("  while creating CONST_RESOURCES.");
                printWriter.print(string + string + "null");
            } else {
                printWriter.print(string + string + string5);
            }
            if (n3 + 1 < stringArray.length) {
                printWriter.println(",");
            } else {
                printWriter.println("");
            }
            ++n3;
        }
        printWriter.println(string + string + "};");
        printWriter.println();
        printWriter.println(string + "public static String StringForResource(" + "com.hp.hpl.jena.rdf.model.Resource" + " resource) {");
        printWriter.println(string + "    return " + "org.daml.kazuki.ModelUtil" + ".StringForResource(CONST_RESOURCES, CONST_STRINGS, resource);");
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public static " + (String)object + " ResourceForString(String str) {");
        printWriter.println(string + "    " + "com.hp.hpl.jena.rdf.model.Resource" + " r = " + "org.daml.kazuki.ModelUtil" + ".ResourceForString(CONST_RESOURCES, CONST_STRINGS, str);");
        printWriter.println(string + "    if (r != null && r.canAs(" + (String)object + ".class)) {");
        printWriter.println(string + "        return (" + (String)object + ")r.as(" + (String)object + ".class); ");
        printWriter.println(string + "    }");
        printWriter.println(string + "    return null;");
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public static String[] getStringArray() {");
        printWriter.println(string + "    String[] copy = new String[CONST_STRINGS.length];");
        printWriter.println(string + "    System.arraycopy(CONST_STRINGS, 0, copy, 0, CONST_STRINGS.length);");
        printWriter.println(string + "    return copy;");
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public static " + (String)object + "[] getResourceArray() {");
        printWriter.println(string + "    " + (String)object + "[] copy = new " + (String)object + "[CONST_RESOURCES.length];");
        printWriter.println(string + "    for (int i = 0; i < copy.length; i++) {");
        printWriter.println(string + "        copy[i] = (" + (String)object + ")CONST_RESOURCES[i].as(" + (String)object + ".class);");
        printWriter.println(string + "    }");
        printWriter.println();
        printWriter.println(string + "    return copy;");
        printWriter.println(string + "}");
        printWriter.println();
    }

    private void generateImplPropertyMethods(String string, OntClass ontClass, Datatypes datatypes, PrintWriter printWriter) {
        Iterator iterator = this.generateClassProperties(ontClass).iterator();
        if (iterator.hasNext()) {
            printWriter.println();
        }
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            this.generateImplPropertyMethod(string, resource, ontClass, datatypes, printWriter);
            printWriter.println();
        }
    }

    private void generateImplPropertyMethod(String string, Resource resource, OntClass ontClass, Datatypes datatypes, PrintWriter printWriter) {
        String string2;
        int n;
        String string3;
        String string4;
        RDFDatatype rDFDatatype;
        String string5 = resource.getLocalName();
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        String string8 = null;
        String string9 = null;
        boolean bl2 = false;
        String string10 = null;
        if (resource.canAs(class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = GenerateInterface.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty)) {
            bl2 = false;
            rDFDatatype = this.getPropertyRange((DatatypeProperty)resource.as(class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = GenerateInterface.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty), ontClass);
            if (rDFDatatype != null) {
                if (rDFDatatype instanceof NonDatatype) {
                    bl2 = true;
                    string6 = "com.hp.hpl.jena.rdf.model.Resource";
                    string4 = ((NonDatatype)rDFDatatype).ontClass;
                    if (string4 != null && (string3 = this.classCatalog.getKazukiClass((OntClass)string4)) != null) {
                        string6 = string3;
                    }
                    System.err.println("WARNING: Using range " + string4 + " for property " + resource + " even though it is defined as a datatype property");
                } else {
                    string9 = rDFDatatype.getURI();
                    string4 = datatypes.getType(string9);
                    if (string4 != null) {
                        string6 = string4;
                        try {
                            Class.forName(string6).getName();
                            bl = true;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            bl = false;
                        }
                        string8 = datatypes.getMethod(string6);
                        if (string8 == null) {
                            System.err.println("SKIPPING: No datatype method for " + string6);
                            string6 = null;
                        }
                    } else {
                        System.err.println("SKIPPING: No Java class for datatype " + rDFDatatype);
                    }
                }
            } else {
                System.err.println("INFO: Using String because no type found for datatype property " + resource);
                string6 = (class$java$lang$String == null ? (class$java$lang$String = GenerateInterface.class$("java.lang.String")) : class$java$lang$String).getName();
                string8 = datatypes.getMethod(string6);
                string9 = XSD.xstring.getURI();
            }
        } else if (resource.canAs(class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = GenerateInterface.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty)) {
            bl2 = true;
            string6 = "com.hp.hpl.jena.rdf.model.Resource";
            rDFDatatype = this.getPropertyRange((ObjectProperty)resource.as(class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = GenerateInterface.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty), ontClass);
            if (rDFDatatype != null && (string4 = this.classCatalog.getKazukiClass((OntClass)rDFDatatype)) != null) {
                string6 = string4;
            }
        } else {
            System.err.println("UNIMPLEMENTED: General Property " + resource);
        }
        if (string6 == null) {
            return;
        }
        string10 = JavaUtil.makeJavaValidName(string5);
        string7 = string6;
        if (string6 != null && string6.lastIndexOf(46) >= 0) {
            string7 = string6.substring(string6.lastIndexOf(46) + 1);
        }
        if (string6.startsWith("java.lang.")) {
            string6 = string7;
        }
        string4 = (n = this.determinePropertyType(string6)) == 1 ? "org.daml.kazuki.iterators." + string6.substring(0, 1).toUpperCase() + string6.substring(1) + "Iterator" : "com.hp.hpl.jena.util.iterator.ExtendedIterator";
        string3 = ModelUtil.makePropertyName("add", string10);
        String string11 = ModelUtil.makePropertyName("set", string10);
        String string12 = ModelUtil.makePropertyName("list", string10);
        String string13 = ModelUtil.makePropertyName("get", string10);
        String string14 = ModelUtil.makePropertyName("has", string10);
        String string15 = ModelUtil.makePropertyName("remove", string10);
        String string16 = ModelUtil.makePropertyName("removeAll", string10);
        String string17 = this.vocabCatalog.getVocabTerm(resource);
        String string18 = string + this.INDENT;
        String string19 = string18 + this.INDENT;
        String string20 = string19 + this.INDENT;
        String string21 = string20 + this.INDENT;
        printWriter.println();
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println(string + "// " + string10 + "    " + string6);
        printWriter.println(string + "//////////////////////////////////////////////////");
        printWriter.println();
        if (string17 == null) {
            System.err.println("WARNING: Could not find vocabulary term for " + resource.getURI());
            System.err.println("   Skipping Property Methods");
            printWriter.println(string + "// Skipped - no vocabulary term ");
            return;
        }
        printWriter.println(string + "public void " + string3 + "(" + string6 + " " + string10 + ")");
        printWriter.println(string + "{");
        if (bl2) {
            printWriter.println(string18 + "addProperty(" + string17 + ", " + string10 + ");");
        } else {
            printWriter.println(string18 + "addProperty(" + string17 + ", " + "org.daml.kazuki.Datatypes.createTypedLiteral" + "(getModel(), " + string10 + ", \"" + string9 + "\"));");
        }
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public void " + string11 + "(" + string6 + " " + string10 + ")");
        printWriter.println(string + "{");
        if (bl2) {
            printWriter.println(string18 + "setPropertyValue(" + string17 + ", " + string10 + ");");
        } else {
            printWriter.println(string18 + "setPropertyValue(" + string17 + ", " + "org.daml.kazuki.Datatypes.createTypedLiteral" + "(getModel(), " + string10 + ", \"" + string9 + "\"));");
        }
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public " + string4 + " " + string12 + "()");
        printWriter.println(string + "{");
        if (n == 1) {
            printWriter.println(string18 + "return new " + string4 + "( listProperties( " + string17 + " ) );");
        } else if (n == 3) {
            printWriter.println(string18 + "return " + "com.hp.hpl.jena.util.iterator.WrappedIterator" + ".create( listProperties( " + string17 + " ) )");
            printWriter.println(string19 + ".mapWith( " + string6 + ".objectMapper ).filterDrop(" + "org.daml.kazuki.ModelUtil.nullFilter" + ");");
        } else if (n == 2 || n == 4) {
            string2 = string6.lastIndexOf(".") == -1 ? string6 : string6.substring(string6.lastIndexOf(".") + 1);
            printWriter.println(string18 + "return " + "com.hp.hpl.jena.util.iterator.WrappedIterator" + ".create( listProperties( " + string17 + " ) )");
            printWriter.println(string19 + ".mapWith( " + "org.daml.kazuki.ModelUtil" + ".objectAs" + string2 + "Mapper ).filterDrop(" + "org.daml.kazuki.ModelUtil.nullFilter" + ");");
        } else {
            new RuntimeException("Shouldn't ever get here!");
        }
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public " + string6 + " " + string13 + "()");
        printWriter.println(string + "{");
        if (bl2) {
            printWriter.println(string18 + "com.hp.hpl.jena.rdf.model.RDFNode" + " n = getPropertyValue(" + string17 + ");");
            printWriter.println(string18 + "if (n.canAs(" + string6 + ".class)) {");
            printWriter.println(string19 + "return (" + string6 + ")n.as(" + string6 + ".class);");
            printWriter.println(string18 + "} else {");
            printWriter.println(string19 + "return null;");
            printWriter.println(string18 + "}");
        } else {
            printWriter.println(string18 + "com.hp.hpl.jena.rdf.model.RDFNode" + " n = getPropertyValue(" + string17 + ");");
            printWriter.println(string18 + "if (n instanceof " + "com.hp.hpl.jena.rdf.model.Literal" + ") {");
            printWriter.println(string19 + "com.hp.hpl.jena.rdf.model.Literal" + " l = (" + "com.hp.hpl.jena.rdf.model.Literal" + ")n;");
            printWriter.println(string19 + "return " + string8 + "(l);");
            printWriter.println(string18 + "} else {");
            printWriter.println(string19 + "throw new " + "com.hp.hpl.jena.rdf.model.LiteralRequiredException" + "(n);");
            printWriter.println(string18 + "}");
        }
        printWriter.println(string + "}");
        printWriter.println();
        string2 = "";
        printWriter.println(string + "public boolean " + string14 + "(" + string6 + " " + string10 + ")");
        printWriter.println(string + "{");
        printWriter.println(string18 + "return hasProperty(" + string17 + ", " + string10 + ");");
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public void " + string15 + "(" + string6 + " " + string10 + ")");
        printWriter.println(string + "{");
        if (bl2) {
            printWriter.println(string18 + "removeProperty(" + string17 + ", " + string10 + ");");
        } else {
            printWriter.println(string18 + "removeProperty(" + string17 + ", " + "org.daml.kazuki.Datatypes.createTypedLiteral" + "(getModel(), " + string10 + ", \"" + string9 + "\"));");
        }
        printWriter.println(string + "}");
        printWriter.println();
        printWriter.println(string + "public void " + string16 + "()");
        printWriter.println(string + "{");
        printWriter.println(string18 + "removeAll(" + string17 + ");");
        printWriter.println(string + "}");
        printWriter.println();
    }

    private int determinePropertyType(String string) {
        if (string.equals("int") || string.equals("short") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("byte") | string.equals("boolean")) {
            return 1;
        }
        if (string.equals("java.math.BigInteger") || string.equals("java.math.BigDecimal") || string.equals("java.util.Calendar") || string.equals("String")) {
            return 2;
        }
        if (string.equals("com.hp.hpl.jena.rdf.model.Resource")) {
            return 4;
        }
        return 3;
    }

    private void generateCustom(OntClass ontClass, String string, File file) throws FileNotFoundException {
        try {
            PrintWriter printWriter = this.openOutputFile(file, this.OPT_OVERWRITE_P);
            printWriter.println("/*");
            printWriter.println(" * " + file.getName());
            if (this.OPT_DATE_P) {
                printWriter.println(" *");
                printWriter.println(" * Created on " + new Date());
            }
            printWriter.println(" */");
            printWriter.println();
            if (this.basePackage.length() > 0) {
                printWriter.println("package " + this.customPackage + ";");
                printWriter.println();
            }
            printWriter.println("/*");
            printWriter.println(" *");
            printWriter.println(" * @author Autogenerated");
            printWriter.println(" */");
            printWriter.println("public class " + string);
            printWriter.println(this.INDENT + "extends " + JavaUtil.makePackage(this.basePackage, string));
            printWriter.println();
            printWriter.println("{");
            this.generateFactory(this.INDENT, ontClass, printWriter);
            this.generateRegister(this.INDENT, ontClass, printWriter, true);
            this.generateObjectMapper(this.INDENT, ontClass, printWriter);
            this.generateConstructor(this.INDENT, ontClass, printWriter);
            this.generateCreateMethods(this.INDENT, ontClass, printWriter);
            printWriter.println("}");
            printWriter.flush();
            printWriter.close();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("SKIPPING: Custom file exists for " + string + " use -OVERWRITE flag to overwrite");
        }
    }

    private RDFDatatype getPropertyRange(DatatypeProperty datatypeProperty, OntClass ontClass) {
        RDFDatatype rDFDatatype;
        OntResource ontResource;
        OntClass ontClass2;
        boolean bl = false;
        Object var4_4 = null;
        ExtendedIterator extendedIterator = ontClass.listSuperClasses();
        while (extendedIterator.hasNext()) {
            ontClass2 = (OntClass)extendedIterator.next();
            if (!ontClass2.canAs(class$com$hp$hpl$jena$ontology$AllValuesFromRestriction == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.AllValuesFromRestriction") : class$com$hp$hpl$jena$ontology$AllValuesFromRestriction)) continue;
            ontResource = (AllValuesFromRestriction)ontClass2.as(class$com$hp$hpl$jena$ontology$AllValuesFromRestriction == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.AllValuesFromRestriction") : class$com$hp$hpl$jena$ontology$AllValuesFromRestriction);
            try {
                RDFDatatype rDFDatatype2;
                rDFDatatype = ontResource.getOnProperty();
                if (!rDFDatatype.equals((Object)datatypeProperty)) continue;
                Resource resource = ontResource.getAllValuesFrom();
                if (bl) {
                    System.out.println(datatypeProperty + " : " + ontClass + " -> " + resource + " ( " + resource.getClass().getName() + " )");
                    System.out.println("OntClass: " + resource.canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass));
                    System.out.println("DataRange: " + resource.canAs(class$com$hp$hpl$jena$ontology$DataRange == null ? (class$com$hp$hpl$jena$ontology$DataRange = GenerateInterface.class$("com.hp.hpl.jena.ontology.DataRange")) : class$com$hp$hpl$jena$ontology$DataRange));
                    System.out.println("Datatype: " + TypeMapper.getInstance().getTypeByName(resource.getURI()));
                }
                if ((rDFDatatype2 = TypeMapper.getInstance().getTypeByName(resource.getURI())) != null) {
                    extendedIterator.close();
                    return rDFDatatype2;
                }
                if (resource.equals((Object)RDFS.Literal)) {
                    extendedIterator.close();
                    return XSDDatatype.XSDstring;
                }
                if (resource.canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)) {
                    if (resource.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
                        extendedIterator.close();
                        return TypeMapper.getInstance().getTypeByName(resource.getURI());
                    }
                    extendedIterator.close();
                    return new NonDatatype((OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass));
                }
                if (resource instanceof DataRange) {
                    System.err.println("UNIMPLEMENTED: Datatype property " + datatypeProperty + " takes part in an allValuesFrom Restriction over a data range");
                    extendedIterator.close();
                    return null;
                }
                System.err.println("ERROR: Could not find a suitable datatype matching " + resource + " while finding range of " + datatypeProperty);
                extendedIterator.close();
                return null;
            }
            catch (ConversionException conversionException) {
                System.err.println("WARNING: Error while processing a restriction on " + ontClass);
            }
        }
        extendedIterator.close();
        ontClass2 = datatypeProperty.listRange();
        ontResource = null;
        if (ontClass2.hasNext()) {
            ontResource = (OntResource)ontClass2.next();
            if (ontClass2.hasNext()) {
                // empty if block
            }
        }
        ontClass2.close();
        if (ontResource != null) {
            rDFDatatype = TypeMapper.getInstance().getTypeByName(ontResource.getURI());
            return rDFDatatype;
        }
        return null;
    }

    private OntClass getPropertyRange(ObjectProperty objectProperty, OntClass ontClass) {
        OntResource ontResource;
        OntClass ontClass2;
        boolean bl = false;
        ExtendedIterator extendedIterator = ontClass.listSuperClasses();
        while (extendedIterator.hasNext()) {
            ontClass2 = (OntClass)extendedIterator.next();
            if (!ontClass2.canAs(class$com$hp$hpl$jena$ontology$AllValuesFromRestriction == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.AllValuesFromRestriction") : class$com$hp$hpl$jena$ontology$AllValuesFromRestriction)) continue;
            ontResource = (AllValuesFromRestriction)ontClass2.as(class$com$hp$hpl$jena$ontology$AllValuesFromRestriction == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.AllValuesFromRestriction") : class$com$hp$hpl$jena$ontology$AllValuesFromRestriction);
            try {
                OntProperty ontProperty = ontResource.getOnProperty();
                if (!ontProperty.equals((Object)objectProperty)) continue;
                Resource resource = ontResource.getAllValuesFrom();
                if (bl) {
                    System.out.println(objectProperty + " : " + ontClass + " -> " + resource + " ( " + resource.getClass().getName() + " )");
                }
                if (resource.equals((Object)RDFS.Literal)) {
                    System.err.println("WARNING/UNIMPLEMENTED: Object property " + objectProperty + " takes part in an allValuesFromRestriction over " + resource);
                    extendedIterator.close();
                    return null;
                }
                if (resource.canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)) {
                    if (!resource.isAnon() && resource.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral")) {
                        System.err.println("WARNING/UNIMPLEMENTED: Object property " + objectProperty + " takes part in an allValuesFromRestriction over " + resource);
                        extendedIterator.close();
                        return null;
                    }
                    extendedIterator.close();
                    return (OntClass)resource.as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
                }
                if (resource instanceof DataRange) {
                    System.err.println("UNIMPLEMENTED: Datatype property " + objectProperty + " takes part in an allValuesFromRestriction over a oneOf data range");
                    extendedIterator.close();
                    return null;
                }
                System.err.println("WARNING/UNIMPLEMENTED: Object property " + objectProperty + " takes part in an allValuesFromRestriction over " + resource);
                extendedIterator.close();
                return null;
            }
            catch (ConversionException conversionException) {
                System.err.println("WARNING: Error occurred while processing restriction on " + ontClass);
            }
        }
        extendedIterator.close();
        ontClass2 = objectProperty.listRange();
        ontResource = null;
        if (ontClass2.hasNext()) {
            ontResource = (OntResource)ontClass2.next();
            if (ontClass2.hasNext()) {
                // empty if block
            }
        }
        ontClass2.close();
        if (ontResource != null) {
            if (ontResource.canAs(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = GenerateInterface.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass)) {
                return ontResource.asClass();
            }
            System.err.println("WARNING/UNIMPLEMENTED: Object property " + objectProperty + " has a non-class range of " + ontResource);
            return null;
        }
        return null;
    }

    private PrintWriter openOutputFile(File file, boolean bl) throws IllegalAccessException, FileNotFoundException {
        if (file.exists() && !bl) {
            throw new IllegalAccessException("Output file " + file + " already exists !!! Use -OVERWRITE flag to overwrite.");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return new PrintWriter(fileOutputStream);
    }

    private SortedSet makeResourceSet(OntModel ontModel, ClassFilter classFilter) {
        ExtendedIterator extendedIterator = ontModel.listClasses();
        ResIterator resIterator = ontModel.listSubjectsWithProperty(RDF.type, (RDFNode)RDFS.Class);
        return this.makeResourceSet((Iterator)extendedIterator.andThen((ClosableIterator)resIterator), classFilter);
    }

    private SortedSet makeResourceSet(Iterator iterator, ClassFilter classFilter) {
        TreeSet<Resource> treeSet = new TreeSet<Resource>(new ResourceComparator());
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (classFilter != null && !classFilter.accept(resource)) continue;
            treeSet.add(resource);
        }
        if (iterator instanceof ExtendedIterator) {
            ((ExtendedIterator)iterator).close();
        }
        return treeSet;
    }

    private Set generateClassProperties(OntClass ontClass) {
        ExtendedIterator extendedIterator;
        ResourceComparator resourceComparator = new ResourceComparator();
        TreeSet<Resource> treeSet = Collections.EMPTY_SET;
        try {
            extendedIterator = ontClass.listDeclaredProperties();
            treeSet = JavaUtil.makeIteratorSortedSet((Iterator)extendedIterator, resourceComparator);
        }
        catch (ConversionException conversionException) {
            System.err.println("WARNING: Unable to determine the properties of class " + ontClass + ".");
            System.err.println("  Data for a referenced property is missing, either because of a missing imports statement, or possibly because of a bug in Jena..");
            System.err.println("  Some properties may be missing from this class.");
            treeSet = Collections.EMPTY_SET;
        }
        extendedIterator = ontClass.listSuperClasses();
        while (extendedIterator.hasNext()) {
            Statement statement;
            Resource resource;
            Resource resource2 = (Resource)extendedIterator.next();
            if (!resource2.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? GenerateInterface.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction) || (resource = (statement = resource2.getProperty(OWL.onProperty)).getResource()) == null) continue;
            if (treeSet == Collections.EMPTY_SET) {
                treeSet = new TreeSet<Resource>(resourceComparator);
            }
            treeSet.add(resource);
        }
        extendedIterator.close();
        return treeSet;
    }

    private Set listDeclaredPropertiesBackup(OntClass ontClass) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Model model = ontClass.getModel();
        StmtIterator stmtIterator = model.listStatements(null, RDFS.domain, (RDFNode)ontClass);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            hashSet.add(resource);
        }
        return hashSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ResourceComparator
    implements Comparator {
        private ResourceComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = -1;
            if (object instanceof Resource && object2 instanceof Resource) {
                Resource resource = (Resource)object;
                Resource resource2 = (Resource)object2;
                String string = resource.getURI();
                String string2 = resource2.getURI();
                if (string2 != null && string != null) {
                    n = string.compareTo(string2);
                }
            }
            return n;
        }
    }

    public static class JavaModelClassFilter
    implements ClassFilter {
        public boolean accept(Resource resource) {
            boolean bl = true;
            if (resource == null) {
                bl = false;
            } else if (resource.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = GenerateInterface.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction)) {
                bl = false;
            } else if (resource.isAnon()) {
                bl = false;
            } else {
                String string = resource.getNameSpace();
                Resource resource2 = OWL.NAMESPACE;
                String string2 = "";
                if (resource2 instanceof String) {
                    string2 = (String)resource2;
                } else if (resource2 instanceof Resource) {
                    string2 = resource2.getURI();
                }
                String string3 = XSD.xstring.getNameSpace();
                if (string.startsWith(string2) || string.startsWith(RDFS.getURI()) || string.startsWith(RDF.getURI()) || string.startsWith(string3)) {
                    bl = false;
                }
            }
            return bl;
        }
    }

    public static interface ClassFilter {
        public boolean accept(Resource var1);
    }
}

