/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki.datatypes;

import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Map1;
import org.daml.kazuki.Datatypes;

public class XSDduration {
    private int years = 0;
    private int months = 0;
    private int days = 0;
    private int hours = 0;
    private int minutes = 0;
    private double seconds = 0.0;
    private int sign = 1;
    public static Map1 objectMapper = new ObjectMapper();

    public XSDduration(XSDDuration xSDDuration) {
        this.setDuration(xSDDuration);
    }

    public XSDduration(boolean bl, int n, int n2, int n3, int n4, int n5, double d) {
        this.setDuration(bl, n, n2, n3, n4, n5, d);
    }

    public void setDuration(XSDDuration xSDDuration) {
        this.setPositive(!xSDDuration.toString().startsWith("-"));
        this.setYears(xSDDuration.getYears() * this.sign);
        this.setMonths(xSDDuration.getMonths() * this.sign);
        this.setDays(xSDDuration.getDays() * this.sign);
        this.setHours(xSDDuration.getHours() * this.sign);
        this.setMinutes(xSDDuration.getMinutes() * this.sign);
        this.setSeconds(xSDDuration.getSeconds() * (double)this.sign);
    }

    public void setDuration(boolean bl, int n, int n2, int n3, int n4, int n5, double d) {
        this.setPositive(bl);
        this.setYears(n);
        this.setMonths(n2);
        this.setDays(n3);
        this.setHours(n4);
        this.setMinutes(n5);
        this.setSeconds(d);
    }

    public void setPositive(boolean bl) {
        this.sign = bl ? 1 : -1;
    }

    public void setYears(int n) {
        if (n >= 0) {
            this.years = n;
        }
    }

    public void setMonths(int n) {
        if (n >= 0) {
            this.months = n;
        }
    }

    public void setDays(int n) {
        if (n >= 0) {
            this.days = n;
        }
    }

    public void setHours(int n) {
        if (n >= 0) {
            this.hours = n;
        }
    }

    public void setMinutes(int n) {
        if (n >= 0) {
            this.minutes = n;
        }
    }

    public void setSeconds(double d) {
        if (d >= 0.0) {
            this.seconds = d;
        }
    }

    public boolean isPositive() {
        return this.sign == 1;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sign < 0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        stringBuffer.append(this.years);
        stringBuffer.append('Y');
        stringBuffer.append(this.months);
        stringBuffer.append('M');
        stringBuffer.append(this.days);
        stringBuffer.append('D');
        stringBuffer.append('T');
        stringBuffer.append(this.hours);
        stringBuffer.append('H');
        stringBuffer.append(this.minutes);
        stringBuffer.append('M');
        stringBuffer.append(this.seconds);
        stringBuffer.append('S');
        return stringBuffer.toString();
    }

    protected static class ObjectMapper
    implements Map1 {
        protected ObjectMapper() {
        }

        public Object map1(Object object) {
            if (object instanceof Statement) {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getDuration(literal);
            }
            throw new IllegalArgumentException("RDF Statement expected while converting an XSDDuration.");
        }
    }
}

