/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki.datatypes;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Map1;
import org.daml.kazuki.Datatypes;

public class XSDgYearMonth {
    private int year = 0;
    private int month = 0;
    private static final int MIN_MONTH = 1;
    private static final int MAX_MONTH = 12;
    public static Map1 objectMapper = new ObjectMapper();

    public XSDgYearMonth(XSDDateTime xSDDateTime) {
        this.setYear(xSDDateTime.getYears());
        this.setMonth(xSDDateTime.getMonths());
    }

    public XSDgYearMonth(int n, int n2) {
        this.setYear(n);
        this.setMonth(n2);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public void setMonth(int n) {
        if (1 <= n && n <= 12) {
            this.month = n;
        }
    }

    public int getMonth() {
        return this.month;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getYear();
        if (n < 0) {
            stringBuffer.append("-");
            n *= -1;
        }
        if (n == 0) {
            stringBuffer.append("0000");
        } else if (n < 10) {
            stringBuffer.append("000");
            stringBuffer.append(n);
        } else if (n < 100) {
            stringBuffer.append("00");
            stringBuffer.append(n);
        } else if (n < 1000) {
            stringBuffer.append("0");
            stringBuffer.append(n);
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append("-");
        if (this.month < 10) {
            stringBuffer.append("0");
            stringBuffer.append(this.month);
        } else {
            stringBuffer.append(this.month);
        }
        return stringBuffer.toString();
    }

    protected static class ObjectMapper
    implements Map1 {
        protected ObjectMapper() {
        }

        public Object map1(Object object) {
            if (object instanceof Statement) {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getgYearMonth(literal);
            }
            throw new IllegalArgumentException("RDF Statement expected while converting an XSDgYearMonth.");
        }
    }
}

