/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd;

public class AbstractDateTime {
    protected int[] data;
    protected double fractionalSeconds;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    public static final short LESS_THAN = -1;
    public static final short EQUAL = 0;
    public static final short GREATER_THAN = 1;
    public static final short INDETERMINATE = 2;

    public AbstractDateTime(Object object) {
        this.data = (int[])object;
        if (this.data[7] == 0) {
            this.data[7] = 90;
        }
        this.extractFractionalSeconds();
    }

    public int compare(AbstractDateTime abstractDateTime) {
        return this.compareDates(this.data, abstractDateTime.data, true);
    }

    protected void extractFractionalSeconds() {
        if (this.data[6] != 0) {
            int n = this.data[6];
            double d = Math.log(n) / 2.302585093;
            int n2 = 1 + (int)(d / 10.0);
            this.fractionalSeconds = (double)n / Math.pow(10.0, n2);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractDateTime) {
            AbstractDateTime abstractDateTime = (AbstractDateTime)object;
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == abstractDateTime.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            n = n << 1 ^ this.data[i];
        }
        return n;
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        if (nArray[7] == nArray2[7]) {
            return this.compareOrder(nArray, nArray2);
        }
        int[] nArray3 = new int[8];
        int[] nArray4 = new int[2];
        if (nArray[7] == 90) {
            this.cloneDate(nArray2, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 43;
            AbstractDateTime.normalize(nArray3, nArray4);
            short s = this.compareOrder(nArray, nArray3);
            if (s == -1) {
                return s;
            }
            this.cloneDate(nArray2, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 45;
            AbstractDateTime.normalize(nArray3, nArray4);
            short s2 = this.compareOrder(nArray, nArray3);
            if (s2 == 1) {
                return s2;
            }
            return 2;
        }
        if (nArray2[7] == 90) {
            this.cloneDate(nArray, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 45;
            AbstractDateTime.normalize(nArray3, nArray4);
            short s = this.compareOrder(nArray3, nArray2);
            if (s == -1) {
                return s;
            }
            this.cloneDate(nArray, nArray3);
            nArray4[0] = 14;
            nArray4[1] = 0;
            nArray3[7] = 43;
            AbstractDateTime.normalize(nArray3, nArray4);
            short s3 = this.compareOrder(nArray3, nArray2);
            if (s3 == 1) {
                return s3;
            }
            return 2;
        }
        return 2;
    }

    protected short compareOrder(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 8; ++i) {
            if (nArray[i] < nArray2[i]) {
                return -1;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    public static void normalize(int[] nArray, int[] nArray2) {
        int n = 1;
        if (nArray[7] == 43) {
            n = -1;
        }
        int n2 = nArray[4] + n * nArray2[1];
        int n4 = AbstractDateTime.fQuotient(n2, 60);
        nArray[4] = AbstractDateTime.mod(n2, 60, n4);
        n2 = nArray[3] + n * nArray2[0] + n4;
        n4 = AbstractDateTime.fQuotient(n2, 24);
        nArray[3] = AbstractDateTime.mod(n2, 24, n4);
        nArray[2] = nArray[2] + n4;
        while (true) {
            n2 = AbstractDateTime.maxDayInMonthFor(nArray[0], nArray[1]);
            if (nArray[2] < 1) {
                nArray[2] = nArray[2] + AbstractDateTime.maxDayInMonthFor(nArray[0], nArray[1] - 1);
                n4 = -1;
            } else {
                if (nArray[2] <= n2) break;
                nArray[2] = nArray[2] - n2;
                n4 = 1;
            }
            n2 = nArray[1] + n4;
            nArray[1] = AbstractDateTime.modulo(n2, 1, 13);
            nArray[0] = nArray[0] + AbstractDateTime.fQuotient(n2, 1, 13);
        }
        nArray[7] = 90;
    }

    protected void resetDateObj(int[] nArray) {
        for (int i = 0; i < 8; ++i) {
            nArray[i] = 0;
        }
    }

    protected static int maxDayInMonthFor(int n, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (AbstractDateTime.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    protected static int mod(int n, int n2, int n4) {
        return n - n4 * n2;
    }

    protected static int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    protected static int modulo(int n, int n2, int n4) {
        int n5 = n - n2;
        int n6 = n4 - n2;
        return AbstractDateTime.mod(n5, n6, AbstractDateTime.fQuotient(n5, n6)) + n2;
    }

    protected static int fQuotient(int n, int n2, int n4) {
        return AbstractDateTime.fQuotient(n - n2, n4 - n2);
    }

    private void cloneDate(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, 8);
    }
}

