/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class ModelRDB
extends ModelCom
implements Model {
    protected GraphRDB m_graphRDB = null;

    public ModelRDB(IDBConnection iDBConnection) throws RDFRDBException {
        this(BuiltinPersonalities.model, new GraphRDB(iDBConnection, null, null, !iDBConnection.containsDefaultModel()));
    }

    public ModelRDB(IDBConnection iDBConnection, String string) throws RDFRDBException {
        this(BuiltinPersonalities.model, new GraphRDB(iDBConnection, string, null, !iDBConnection.containsDefaultModel()));
    }

    public ModelRDB(GraphPersonality graphPersonality, GraphRDB graphRDB) throws RDFRDBException {
        super(graphRDB, graphPersonality);
        this.m_graphRDB = graphRDB;
    }

    public ModelRDB(GraphRDB graphRDB) {
        super(graphRDB);
        this.m_graphRDB = graphRDB;
    }

    public static ModelRDB open(IDBConnection iDBConnection) throws RDFRDBException {
        return ModelRDB.open(iDBConnection, null);
    }

    public static ModelRDB open(IDBConnection iDBConnection, String string) throws RDFRDBException {
        GraphRDB graphRDB = new GraphRDB(iDBConnection, string, null, 3, false);
        return new ModelRDB(BuiltinPersonalities.model, graphRDB);
    }

    public static ModelRDB createModel(IDBConnection iDBConnection) throws RDFRDBException {
        return ModelRDB.createModel(iDBConnection, null, ModelRDB.getDefaultModelProperties(iDBConnection));
    }

    public static ModelRDB createModel(IDBConnection iDBConnection, Model model) throws RDFRDBException {
        return ModelRDB.createModel(iDBConnection, null, model);
    }

    public static ModelRDB createModel(IDBConnection iDBConnection, String string) throws RDFRDBException {
        return ModelRDB.createModel(iDBConnection, string, ModelRDB.getDefaultModelProperties(iDBConnection));
    }

    public static ModelRDB createModel(IDBConnection iDBConnection, String string, Model model) throws RDFRDBException {
        GraphRDB graphRDB = model != null ? new GraphRDB(iDBConnection, string, model.getGraph(), 3, true) : new GraphRDB(iDBConnection, string, null, 3, true);
        return new ModelRDB(BuiltinPersonalities.model, graphRDB);
    }

    public static ModelRDB create(IDBConnection iDBConnection, String string, String string2) throws RDFRDBException {
        iDBConnection.setDatabaseType(string2);
        return ModelRDB.createModel(iDBConnection, null, ModelRDB.getDefaultModelProperties(iDBConnection));
    }

    public static ModelRDB create(IDBConnection iDBConnection, String string) throws RDFRDBException {
        iDBConnection.setDatabaseType(string);
        return ModelRDB.createModel(iDBConnection, null, ModelRDB.getDefaultModelProperties(iDBConnection));
    }

    public Model getModelProperties() {
        Model model = ModelFactory.createDefaultModel();
        Graph graph = model.getGraph();
        ExtendedIterator extendedIterator = this.m_graphRDB.getPropertyTriples();
        while (extendedIterator.hasNext()) {
            graph.add((Triple)extendedIterator.next());
        }
        return model;
    }

    public static Model getDefaultModelProperties(IDBConnection iDBConnection) {
        return iDBConnection.getDefaultModelProperties();
    }

    public static ExtendedIterator listModels(IDBConnection iDBConnection) throws RDFRDBException {
        return iDBConnection.getAllModelNames();
    }

    public void close() {
        this.m_graphRDB.close();
    }

    public void remove() throws RDFRDBException {
        this.m_graphRDB.remove();
    }

    public IDBConnection getConnection() {
        return this.m_graphRDB.getConnection();
    }

    public void clear() throws RDFRDBException {
        this.remove();
    }

    public static void deleteModel(IDBConnection iDBConnection, String string) throws RDFRDBException {
        ModelRDB modelRDB = ModelRDB.open(iDBConnection, string);
        modelRDB.remove();
    }

    public Model loadAll() {
        Model model = ModelFactory.createDefaultModel();
        StmtIterator stmtIterator = this.listStatements();
        while (stmtIterator.hasNext()) {
            model.add(stmtIterator.nextStatement());
        }
        return model;
    }

    public boolean getDoDuplicateCheck() {
        return this.m_graphRDB.getDoDuplicateCheck();
    }

    public void setDoDuplicateCheck(boolean bl) {
        this.m_graphRDB.setDoDuplicateCheck(bl);
    }

    public void setDoFastpath(boolean bl) {
        ((DBQueryHandler)this.m_graphRDB.queryHandler()).setDoFastpath(bl);
    }

    public boolean getDoFastpath() {
        return ((DBQueryHandler)this.m_graphRDB.queryHandler()).getDoFastpath();
    }

    public void setQueryOnlyAsserted(boolean bl) {
        ((DBQueryHandler)this.m_graphRDB.queryHandler()).setQueryOnlyAsserted(bl);
    }

    public boolean getQueryOnlyAsserted() {
        return ((DBQueryHandler)this.m_graphRDB.queryHandler()).getQueryOnlyAsserted();
    }

    public void setQueryOnlyReified(boolean bl) {
        ((DBQueryHandler)this.m_graphRDB.queryHandler()).setQueryOnlyReified(bl);
    }

    public boolean getQueryOnlyReified() {
        return ((DBQueryHandler)this.m_graphRDB.queryHandler()).getQueryOnlyReified();
    }

    public void setQueryFullReified(boolean bl) {
        ((DBQueryHandler)this.m_graphRDB.queryHandler()).setQueryFullReified(bl);
    }

    public boolean getQueryFullReified() {
        return ((DBQueryHandler)this.m_graphRDB.queryHandler()).getQueryFullReified();
    }

    public void setDoImplicitJoin(boolean bl) {
        ((DBQueryHandler)this.m_graphRDB.queryHandler()).setDoImplicitJoin(bl);
    }
}

