/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.Driver_MySQL;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTransactions
extends TestCase {
    ModelRDB model = null;
    Model dbProperties = null;
    IDBConnection conn = null;
    DriverRDB m_driver = null;

    public TestTransactions(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTransactions.class);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.dbProperties = this.conn.getDatabaseProperties();
        this.model = ModelRDB.createModel(this.conn);
        this.m_driver = new Driver_MySQL();
        this.m_driver.setConnection(this.conn);
    }

    protected void tearDown() throws Exception {
        this.model.close();
        this.model = null;
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    private void addCommit(Statement statement) {
        this.model.remove(statement);
        this.model.begin();
        this.model.add(statement);
        this.model.commit();
        TestTransactions.assertTrue((boolean)this.model.contains(statement));
    }

    private void addAbort(Statement statement) {
        this.model.remove(statement);
        this.model.begin();
        this.model.add(statement);
        this.model.abort();
        TestTransactions.assertTrue((!this.model.contains(statement) ? 1 : 0) != 0);
    }

    public void testAddCommitURI() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addCommit(this.model.createStatement(resource, property, resource2));
    }

    public void testAddAbortURI() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource("test#object");
        this.addAbort(this.model.createStatement(resource, property, resource2));
    }

    public void testAddCommitLiteral() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createLiteral("testLiteral");
        this.addCommit(this.model.createStatement(resource, property, literal));
    }

    public void testAddCommitHugeLiteral() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createLiteral(stringBuffer.toString());
        this.addCommit(this.model.createStatement(resource, property, literal));
    }

    public void testAddAbortHugeLiteral() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createLiteral(stringBuffer.toString());
        this.addAbort(this.model.createStatement(resource, property, literal));
    }

    public void testAddCommitDatatype() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral("stringType");
        this.addCommit(this.model.createStatement(resource, property, literal));
    }

    public void testAddAbortDatatype() {
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral("stringType");
        this.addAbort(this.model.createStatement(resource, property, literal));
    }

    public void testAddAbortHugeDatatype() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral(stringBuffer.toString());
        this.addAbort(this.model.createStatement(resource, property, literal));
    }

    public void testAddCommitHugeDatatype() {
        String string = "This is a huge string that repeats.";
        StringBuffer stringBuffer = new StringBuffer(4096);
        while (stringBuffer.length() < 4000) {
            stringBuffer.append(string);
        }
        Resource resource = this.model.createResource("test#subject");
        Property property = this.model.createProperty("test#predicate");
        Literal literal = this.model.createTypedLiteral(stringBuffer.toString());
        this.addCommit(this.model.createStatement(resource, property, literal));
    }

    public void testAddCommitBNode() {
        Resource resource = this.model.createResource();
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource();
        this.addCommit(this.model.createStatement(resource, property, resource2));
    }

    public void testAddAbortBNode() {
        Resource resource = this.model.createResource();
        Property property = this.model.createProperty("test#predicate");
        Resource resource2 = this.model.createResource();
        this.addAbort(this.model.createStatement(resource, property, resource2));
    }
}

