/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.n3.N3JenaWriterCommon;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class N3JenaWriterPP
extends N3JenaWriterCommon {
    private final boolean doObjectListsAsLists = this.getBooleanValue("objectLists", true);
    Set rdfLists = null;
    Set rdfListsAll = null;
    Set rdfListsDone = null;
    Set roots = null;
    Set oneRefObjects = null;
    Set oneRefDone = null;
    boolean allowDeep = true;
    static final String objectListSep = " , ";

    protected void prepare(Model model) {
        this.prepareLists(model);
        this.prepareOneRefBNodes(model);
    }

    private void prepareLists(Model model) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        StmtIterator stmtIterator = model.listStatements(null, RDF.rest, RDF.nil);
        while (stmtIterator.hasNext()) {
            boolean bl;
            Resource resource = stmtIterator.nextStatement().getSubject();
            Resource resource2 = null;
            while (bl = this.checkListElement(resource)) {
                if (N3JenaWriter.DEBUG) {
                    this.out.println("# RDF list all: " + this.formatResource(resource));
                }
                resource2 = resource;
                hashSet.add(resource);
                StmtIterator stmtIterator2 = model.listStatements(null, RDF.rest, resource);
                if (!stmtIterator2.hasNext()) break;
                resource = stmtIterator2.nextStatement().getSubject();
                if (!stmtIterator2.hasNext()) continue;
                if (!N3JenaWriter.DEBUG) break;
                this.out.println("# RDF shared tail from " + this.formatResource(resource));
                break;
            }
            if (N3JenaWriter.DEBUG) {
                this.out.println("# DAML list head: " + this.formatResource(resource2));
            }
            this.rdfListsAll.addAll(hashSet);
            if (resource2 == null) continue;
            this.rdfLists.add(resource2);
        }
        stmtIterator.close();
    }

    private boolean checkListElement(Resource resource) {
        if (!resource.hasProperty(RDF.rest) || !resource.hasProperty(RDF.first)) {
            if (N3JenaWriter.DEBUG) {
                this.out.println("# RDF list element does not have required properties: " + this.formatResource(resource));
            }
            return false;
        }
        int n = this.countProperties(resource);
        if (n == 2) {
            return true;
        }
        if (n == 3) {
            if (resource.hasProperty(RDF.type, RDF.List)) {
                return true;
            }
            if (N3JenaWriter.DEBUG) {
                this.out.println("# RDF list element: 3 properties but no rdf:type rdf:List" + this.formatResource(resource));
            }
            return false;
        }
        if (N3JenaWriter.DEBUG) {
            this.out.println("# RDF list element does not right number of properties: " + this.formatResource(resource));
        }
        return false;
    }

    private void prepareOneRefBNodes(Model model) {
        NodeIterator nodeIterator = model.listObjects();
        while (nodeIterator.hasNext()) {
            RDFNode rDFNode = nodeIterator.nextNode();
            if (this.testOneRefBNode(rDFNode)) {
                this.oneRefObjects.add(rDFNode);
            }
            nodeIterator.close();
            if (!N3JenaWriter.DEBUG) continue;
            this.out.println("# RDF Lists      = " + this.rdfLists.size());
            this.out.println("# RDF ListsAll   = " + this.rdfListsAll.size());
            this.out.println("# oneRefObjects  = " + this.oneRefObjects.size());
        }
    }

    private boolean testOneRefBNode(RDFNode rDFNode) {
        if (!(rDFNode instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)rDFNode;
        if (!resource.isAnon()) {
            return false;
        }
        if (this.rdfListsAll.contains(resource)) {
            return false;
        }
        StmtIterator stmtIterator = resource.getModel().listStatements(null, null, resource);
        if (!stmtIterator.hasNext()) {
            throw new JenaException("N3: found object with no arcs!");
        }
        Statement statement = stmtIterator.nextStatement();
        if (stmtIterator.hasNext()) {
            return false;
        }
        if (N3JenaWriter.DEBUG) {
            this.out.println("# OneRef: " + this.formatResource(resource));
        }
        return true;
    }

    protected ClosableIterator preparePropertiesForSubject(Resource resource) {
        Object object;
        HashSet<Property> hashSet = new HashSet<Property>();
        boolean bl = false;
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            object = stmtIterator.nextStatement().getPredicate();
            if (hashSet.contains(object)) continue;
            hashSet.add((Property)object);
            if (object.equals(RDF.type)) {
                bl = true;
                continue;
            }
            if (object.getURI().startsWith(RDF.getURI()) || object.getURI().startsWith(RDFS.getURI())) {
                treeMap.put(object.getURI(), object);
                continue;
            }
            treeMap2.put(object.getURI(), object);
        }
        stmtIterator.close();
        object = null;
        if (bl) {
            object = new SingletonIterator(RDF.type);
        }
        ExtendedIterator extendedIterator = WrappedIterator.create(treeMap.values().iterator());
        object = object == null ? extendedIterator : object.andThen(extendedIterator);
        extendedIterator = WrappedIterator.create(treeMap2.values().iterator());
        object = object == null ? extendedIterator : object.andThen(extendedIterator);
        return object;
    }

    protected boolean skipThisSubject(Resource resource) {
        return this.rdfListsAll.contains(resource) || this.oneRefObjects.contains(resource);
    }

    protected void startWriting() {
        this.allocateDatastructures();
    }

    protected void finishWriting() {
        this.oneRefObjects.removeAll(this.oneRefDone);
        Iterator iterator = this.oneRefObjects.iterator();
        while (iterator.hasNext()) {
            this.out.println();
            if (N3JenaWriter.DEBUG) {
                this.out.println("# One ref");
            }
            this.allowDeep = false;
            this.writeOneGraphNode((Resource)iterator.next());
            this.allowDeep = true;
        }
        iterator = this.rdfLists.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (this.rdfListsDone.contains(resource)) continue;
            this.out.println();
            if (N3JenaWriter.DEBUG) {
                this.out.println("# RDF List");
            }
            if (!resource.isAnon() || this.countArcsTo(resource) > 0) {
                this.out.print(this.formatResource(resource));
                this.out.print(" :- ");
            }
            this.writeList(resource);
            this.out.println(" .");
        }
        this.out.flush();
        this.clearDatastructures();
    }

    protected void writeObjectList(Resource resource, Property property) {
        Iterator iterator;
        String string = this.formatProperty(property);
        StmtIterator stmtIterator = resource.listProperties(property);
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        HashSet<RDFNode> hashSet2 = new HashSet<RDFNode>();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            RDFNode rDFNode = statement.getObject();
            if (this.isSimpleObject(rDFNode)) {
                hashSet.add(rDFNode);
                continue;
            }
            hashSet2.add(rDFNode);
        }
        stmtIterator.close();
        int n = hashSet.size();
        int n2 = hashSet2.size();
        if (hashSet.size() > 0) {
            RDFNode rDFNode;
            String string2 = null;
            if (string.length() + this.minGap <= this.widePropertyLen) {
                string2 = N3JenaWriterPP.pad(this.calcPropertyPadding(string));
            }
            if (this.doObjectListsAsLists) {
                this.out.print(string);
                this.out.incIndent(this.indentObject);
                if (string2 != null) {
                    this.out.print(string2);
                } else {
                    this.out.println();
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    rDFNode = (RDFNode)iterator.next();
                    this.writeObject(rDFNode);
                    if (!iterator.hasNext()) continue;
                    this.out.print(objectListSep);
                }
                this.out.decIndent(this.indentObject);
            } else {
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    this.out.print(string);
                    this.out.incIndent(this.indentObject);
                    if (string2 != null) {
                        this.out.print(string2);
                    } else {
                        this.out.println();
                    }
                    rDFNode = (RDFNode)iterator.next();
                    this.writeObject(rDFNode);
                    this.out.decIndent(this.indentObject);
                    if (!iterator.hasNext()) continue;
                    this.out.println(" ;");
                }
            }
        }
        if (hashSet2.size() > 0) {
            if (hashSet.size() > 0) {
                this.out.println(" ;");
            }
            int n4 = -1;
            iterator = null;
            int n5 = string.length();
            if (string.length() + this.minGap <= this.propertyCol) {
                n4 = this.calcPropertyPadding(string);
                iterator = N3JenaWriterPP.pad(n4);
            }
            Iterator iterator2 = hashSet2.iterator();
            while (iterator2.hasNext()) {
                int n6 = this.indentObject;
                this.out.incIndent(n6);
                this.out.print(string);
                if (iterator != null) {
                    this.out.print((String)((Object)iterator));
                } else {
                    this.out.println();
                }
                RDFNode rDFNode = (RDFNode)iterator2.next();
                this.writeObject(rDFNode);
                this.out.decIndent(n6);
                if (!iterator2.hasNext()) continue;
                this.out.println(" ;");
            }
        }
    }

    private boolean isSimpleObject(RDFNode rDFNode) {
        if (rDFNode instanceof Literal) {
            return true;
        }
        Resource resource = (Resource)rDFNode;
        return !this.allowDeep || !this.oneRefObjects.contains(resource);
    }

    protected void writeObject(RDFNode rDFNode) {
        if (rDFNode instanceof Literal) {
            this.writeLiteral((Literal)rDFNode);
            return;
        }
        Resource resource = (Resource)rDFNode;
        if (this.allowDeep && !this.isSimpleObject(resource)) {
            this.oneRefDone.add(resource);
            this.out.print("[ ");
            this.out.incIndent(2);
            this.writePropertiesForSubject(resource);
            this.out.decIndent(2);
            this.out.println();
            this.out.print("]");
            return;
        }
        if (this.rdfLists.contains(resource) && this.countArcsTo(resource) <= 1) {
            this.writeList(resource);
            return;
        }
        this.out.print(this.formatResource(resource));
    }

    private void writeList(Resource resource) {
        this.out.print("(");
        this.out.incIndent(2);
        boolean bl = true;
        Iterator iterator = this.rdfListIterator(resource);
        while (iterator.hasNext()) {
            if (!bl) {
                this.out.print(" ");
            }
            bl = false;
            RDFNode rDFNode = (RDFNode)iterator.next();
            this.writeObject(rDFNode);
        }
        this.out.print(")");
        this.out.decIndent(2);
        this.rdfListsDone.add(resource);
    }

    protected void allocateDatastructures() {
        this.rdfLists = new HashSet();
        this.rdfListsAll = new HashSet();
        this.rdfListsDone = new HashSet();
        this.oneRefObjects = new HashSet();
        this.oneRefDone = new HashSet();
    }

    protected void clearDatastructures() {
        this.rdfLists = null;
        this.rdfListsAll = null;
        this.rdfListsDone = null;
        this.oneRefObjects = null;
        this.oneRefDone = null;
    }
}

