/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.util.Arrays;

final class JenaHandler
extends ARPSaxErrorHandler
implements StatementHandler,
NamespaceHandler {
    private static final int BULK_UPDATE_SIZE = 1000;
    private final BulkUpdateHandler bulk;
    private final Model model;
    final Triple[] triples;
    int ix = 0;

    JenaHandler(Model model, RDFErrorHandler rDFErrorHandler) {
        this(model.getGraph(), model, rDFErrorHandler);
    }

    JenaHandler(Graph graph, RDFErrorHandler rDFErrorHandler) {
        this(graph, null, rDFErrorHandler);
    }

    JenaHandler(Graph graph, Model model, RDFErrorHandler rDFErrorHandler) {
        this(graph.getBulkUpdateHandler(), model, rDFErrorHandler);
    }

    private JenaHandler(BulkUpdateHandler bulkUpdateHandler, Model model, RDFErrorHandler rDFErrorHandler) {
        super(rDFErrorHandler);
        this.bulk = bulkUpdateHandler;
        this.model = model;
        this.triples = new Triple[1000];
    }

    void useWith(ARPHandlers aRPHandlers) {
        aRPHandlers.setStatementHandler(this);
        aRPHandlers.setErrorHandler(this);
        aRPHandlers.setNamespaceHandler(this);
    }

    public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
        try {
            this.triples[this.ix++] = JenaReader.convert(aResource, aResource2, aResource3);
        }
        catch (JenaException jenaException) {
            this.errorHandler.error(jenaException);
        }
        if (this.ix == 1000) {
            this.bulkUpdate();
        }
    }

    public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        try {
            this.triples[this.ix++] = JenaReader.convert(aResource, aResource2, aLiteral);
        }
        catch (JenaException jenaException) {
            this.errorHandler.error(jenaException);
        }
        if (this.ix == 1000) {
            this.bulkUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bulkUpdate() {
        try {
            if (this.ix == 1000) {
                this.bulk.add(this.triples);
            } else {
                this.bulk.add(Arrays.asList(this.triples).subList(0, this.ix));
            }
        }
        catch (JenaException jenaException) {
            this.errorHandler.error(jenaException);
        }
        finally {
            this.ix = 0;
        }
    }

    public void startPrefixMapping(String string, String string2) {
        if (this.model != null && PrefixMappingImpl.isNiceURI(string2)) {
            this.model.setNsPrefix(string, string2);
        }
    }

    public void endPrefixMapping(String string) {
    }
}

