/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import org.xml.sax.Locator;

class Location
implements Locator {
    final String inputName;
    final String publicId;
    final int endLine;
    final int endColumn;

    Location(Locator locator) {
        if (locator == null) {
            this.inputName = "unknown-source";
            this.publicId = "unknown-source";
            this.endLine = -1;
            this.endColumn = -1;
        } else {
            this.inputName = locator.getSystemId();
            this.endLine = locator.getLineNumber();
            this.endColumn = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
        }
    }

    Location(String string, int n, int n2) {
        this.inputName = string;
        this.endLine = n;
        this.endColumn = n2;
        this.publicId = null;
    }

    public String toString() {
        return "line " + this.endLine + " in '" + this.inputName + "'";
    }

    public String getSystemId() {
        return this.inputName;
    }

    public int getLineNumber() {
        return this.endLine;
    }

    public int getColumnNumber() {
        return this.endColumn;
    }

    public String getPublicId() {
        return this.publicId;
    }
}

