/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.BadBooleanException;
import com.hp.hpl.jena.shared.BadCharLiteralException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;

public class LiteralImpl
extends EnhNode
implements Literal {
    public static final Implementation factory = new Implementation(){

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return node.isLiteral();
        }

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (!node.isLiteral()) {
                throw new LiteralRequiredException(node);
            }
            return new LiteralImpl(node, enhGraph);
        }
    };

    public LiteralImpl(Node node, ModelCom modelCom) {
        super(node, modelCom);
    }

    public LiteralImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public Object visitWith(RDFVisitor rDFVisitor) {
        return rDFVisitor.visitLiteral(this);
    }

    public RDFNode inModel(Model model) {
        return this;
    }

    public LiteralImpl(boolean bl) {
        this(String.valueOf(bl));
    }

    public LiteralImpl(long l) {
        this(String.valueOf(l));
    }

    public LiteralImpl(char c) {
        this(String.valueOf(c));
    }

    public LiteralImpl(float f) {
        this(String.valueOf(f));
    }

    public LiteralImpl(double d) {
        this(String.valueOf(d));
    }

    public LiteralImpl(String string) {
        this(string, "");
    }

    public LiteralImpl(String string, String string2) {
        this(string, string2, false);
    }

    public LiteralImpl(String string, boolean bl) {
        this(string, "", bl);
    }

    public LiteralImpl(String string, String string2, boolean bl) {
        this(string, string2, bl, null);
    }

    public LiteralImpl(String string, String string2, boolean bl, ModelCom modelCom) {
        this(Node.createLiteral(string, string2, bl), modelCom);
    }

    public LiteralImpl(Object object) {
        this(object.toString());
    }

    public boolean isLiteral() {
        return true;
    }

    public String toString() {
        return this.asNode().toString(PrefixMapping.Standard, false);
    }

    public Object getValue() {
        return this.asNode().getLiteral().getValue();
    }

    public RDFDatatype getDatatype() {
        return this.asNode().getLiteral().getDatatype();
    }

    public String getDatatypeURI() {
        return this.asNode().getLiteral().getDatatypeURI();
    }

    public boolean isPlainLiteral() {
        return this.asNode().getLiteral().getDatatype() == null;
    }

    public String getLexicalForm() {
        return this.asNode().getLiteral().getLexicalForm();
    }

    public boolean getBoolean() {
        Object object = this.asNode().getLiteral().getValue();
        if (this.isPlainLiteral()) {
            if (object.equals("true")) {
                return true;
            }
            if (object.equals("false")) {
                return false;
            }
            throw new BadBooleanException(object.toString());
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new DatatypeFormatException(this.toString() + " is not a Boolean");
    }

    public byte getByte() {
        if (this.isPlainLiteral()) {
            return Byte.parseByte(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).byteValue();
    }

    public short getShort() {
        if (this.isPlainLiteral()) {
            return Short.parseShort(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).shortValue();
    }

    public int getInt() {
        if (this.isPlainLiteral()) {
            return Integer.parseInt(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).intValue();
    }

    public long getLong() {
        if (this.isPlainLiteral()) {
            return Long.parseLong(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).longValue();
    }

    public char getChar() {
        if (this.isPlainLiteral()) {
            if (this.getString().length() == 1) {
                return this.getString().charAt(0);
            }
            throw new BadCharLiteralException(this.getString());
        }
        Object object = this.getValue();
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw new DatatypeFormatException(object.toString() + " is not a Character");
    }

    public float getFloat() {
        if (this.isPlainLiteral()) {
            return Float.parseFloat(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).floatValue();
    }

    public double getDouble() {
        if (this.isPlainLiteral()) {
            return Double.parseDouble(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).doubleValue();
    }

    public String getString() {
        return this.asNode().getLiteral().getLexicalForm();
    }

    public Object getObject(ObjectF objectF) {
        if (this.isPlainLiteral()) {
            try {
                return objectF.createObject(this.getString());
            }
            catch (Exception exception) {
                throw new JenaException(exception);
            }
        }
        return this.getValue();
    }

    public String getLanguage() {
        return this.asNode().getLiteral().language();
    }

    public boolean getWellFormed() {
        return this.asNode().getLiteral().isXML();
    }

    public boolean sameValueAs(Literal literal) {
        return this.asNode().sameValueAs(literal.asNode());
    }

    private Number asNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new DatatypeFormatException(object.toString() + " is not a Number");
    }
}

