/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.FrontsTriple;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.DisjointUnion;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.RSIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;

public class ModelReifier {
    private ModelCom model;
    public Reifier reifier;
    private static boolean copyingReifications = false;
    protected final Map1 mapToRS = new Map1(){

        public Object map1(Object object) {
            return ModelReifier.this.getRS((Node)object);
        }
    };

    public ModelReifier(ModelCom modelCom) {
        this.model = modelCom;
        this.reifier = modelCom.asGraph().getReifier();
    }

    public ReificationStyle getReificationStyle() {
        return this.reifier.getStyle();
    }

    public static Model withHiddenStatements(Model model) {
        Graph graph = model.getGraph();
        Graph graph2 = ModelReifier.getHiddenTriples(model);
        return new ModelCom(new DisjointUnion(graph, graph2));
    }

    protected static Graph getHiddenTriples(Model model) {
        Graph graph = model.getGraph();
        final Reifier reifier = graph.getReifier();
        return new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                return reifier.findEither(tripleMatch, true);
            }
        };
    }

    public Model getHiddenStatements() {
        return new ModelCom(ModelReifier.getHiddenTriples(this.model));
    }

    public ReifiedStatement createReifiedStatement(Statement statement) {
        return this.createReifiedStatement(null, statement);
    }

    public ReifiedStatement createReifiedStatement(String string, Statement statement) {
        return ReifiedStatementImpl.create(this.model, string, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getAnyReifiedStatement(Statement statement) {
        RSIterator rSIterator = this.listReifiedStatements(statement);
        if (rSIterator.hasNext()) {
            try {
                ReifiedStatement reifiedStatement = rSIterator.nextRS();
                return reifiedStatement;
            }
            finally {
                rSIterator.close();
            }
        }
        return this.createReifiedStatement(statement);
    }

    public boolean isReified(FrontsTriple frontsTriple) {
        return this.reifier.hasTriple(frontsTriple.asTriple());
    }

    public void removeAllReifications(FrontsTriple frontsTriple) {
        this.reifier.remove(frontsTriple.asTriple());
    }

    public void removeReification(ReifiedStatement reifiedStatement) {
        this.reifier.remove(reifiedStatement.asNode(), reifiedStatement.getStatement().asTriple());
    }

    public RSIterator listReifiedStatements() {
        return new RSIteratorImpl(this.findReifiedStatements());
    }

    public RSIterator listReifiedStatements(FrontsTriple frontsTriple) {
        return new RSIteratorImpl(this.findReifiedStatements(frontsTriple.asTriple()));
    }

    public void noteIfReified(RDFNode rDFNode, RDFNode rDFNode2, RDFNode rDFNode3) {
        if (copyingReifications) {
            this.noteIfReified(rDFNode);
            this.noteIfReified(rDFNode2);
            this.noteIfReified(rDFNode3);
        }
    }

    private void noteIfReified(RDFNode rDFNode) {
        if (rDFNode.canAs(ReifiedStatement.class)) {
            ReifiedStatement reifiedStatement = (ReifiedStatement)rDFNode.as(ReifiedStatement.class);
            this.createReifiedStatement(reifiedStatement.getURI(), reifiedStatement.getStatement());
        }
    }

    private ExtendedIterator findReifiedStatements() {
        return this.reifier.allNodes().mapWith(this.mapToRS);
    }

    private ExtendedIterator findReifiedStatements(Triple triple) {
        return this.reifier.allNodes(triple).mapWith(this.mapToRS);
    }

    private ReifiedStatement getRS(Node node) {
        Triple triple = this.reifier.getTriple(node);
        Statement statement = this.model.asStatement(triple);
        return ReifiedStatementImpl.create((EnhGraph)this.model, node, statement);
    }
}

