/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.listeners.ChangedListener;
import com.hp.hpl.jena.rdf.listeners.NullListener;
import com.hp.hpl.jena.rdf.listeners.ObjectListener;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.RecordingModelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestModelEvents
extends ModelTestBase {
    protected Model model;
    protected RecordingModelListener SL;

    public TestModelEvents(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelEvents.class);
    }

    public void setUp() {
        this.model = ModelFactory.createDefaultModel();
        this.SL = new RecordingModelListener();
    }

    public void testRegistrationCompiles() {
        TestModelEvents.assertSame((Object)this.model, (Object)this.model.register(new RecordingModelListener()));
    }

    public void testUnregistrationCompiles() {
        this.model.unregister(new RecordingModelListener());
    }

    public void testAddSingleStatements() {
        Statement statement = TestModelEvents.statement(this.model, "S P O");
        Statement statement2 = TestModelEvents.statement(this.model, "A B C");
        TestModelEvents.assertFalse((boolean)this.SL.has(new Object[]{"add", statement}));
        this.model.register(this.SL);
        this.model.add(statement);
        this.SL.assertHas(new Object[]{"add", statement});
        this.model.add(statement2);
        this.SL.assertHas(new Object[]{"add", statement, "add", statement2});
        this.model.add(statement);
        this.SL.assertHas(new Object[]{"add", statement, "add", statement2, "add", statement});
    }

    public void testTwoListeners() {
        Statement statement = TestModelEvents.statement(this.model, "S P O");
        RecordingModelListener recordingModelListener = new RecordingModelListener();
        RecordingModelListener recordingModelListener2 = new RecordingModelListener();
        this.model.register(recordingModelListener).register(recordingModelListener2);
        this.model.add(statement);
        recordingModelListener2.assertHas(new Object[]{"add", statement});
        recordingModelListener.assertHas(new Object[]{"add", statement});
    }

    public void testUnregisterWorks() {
        this.model.register(this.SL);
        this.model.unregister(this.SL);
        this.model.add(TestModelEvents.statement(this.model, "X R Y"));
        this.SL.assertHas(new Object[0]);
    }

    public void testRemoveSingleStatements() {
        Statement statement = TestModelEvents.statement(this.model, "D E F");
        this.model.register(this.SL);
        this.model.add(statement);
        this.model.remove(statement);
        this.SL.assertHas(new Object[]{"add", statement, "remove", statement});
    }

    public void testAddInPieces() {
        this.model.register(this.SL);
        this.model.add(TestModelEvents.resource(this.model, "S"), TestModelEvents.property(this.model, "P"), TestModelEvents.resource(this.model, "O"));
        this.SL.assertHas(new Object[]{"add", TestModelEvents.statement(this.model, "S P O")});
    }

    public void testAddStatementArray() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "a P b; c Q d");
        this.model.add(statementArray);
        this.SL.assertHas(new Object[]{"add[]", Arrays.asList(statementArray)});
    }

    public void testDeleteStatementArray() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "a P b; c Q d");
        this.model.remove(statementArray);
        this.SL.assertHas(new Object[]{"remove[]", Arrays.asList(statementArray)});
    }

    public void testAddStatementList() {
        this.model.register(this.SL);
        List<Statement> list = Arrays.asList(TestModelEvents.statements(this.model, "b I g; m U g"));
        this.model.add(list);
        this.SL.assertHas(new Object[]{"addList", list});
    }

    public void testDeleteStatementList() {
        this.model.register(this.SL);
        List<Statement> list = Arrays.asList(TestModelEvents.statements(this.model, "b I g; m U g"));
        this.model.remove(list);
        this.SL.assertHas(new Object[]{"removeList", list});
    }

    public void testAddStatementIterator() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "x R y; a P b; x R y");
        StmtIterator stmtIterator = this.asIterator(statementArray);
        this.model.add(stmtIterator);
        this.SL.assertHas(new Object[]{"addIterator", Arrays.asList(statementArray)});
    }

    public void testDeleteStatementIterator() {
        this.model.register(this.SL);
        Statement[] statementArray = TestModelEvents.statements(this.model, "x R y; a P b; x R y");
        StmtIterator stmtIterator = this.asIterator(statementArray);
        this.model.remove(stmtIterator);
        this.SL.assertHas(new Object[]{"removeIterator", Arrays.asList(statementArray)});
    }

    protected StmtIterator asIterator(Statement[] statementArray) {
        return new StmtIteratorImpl(Arrays.asList(statementArray).iterator());
    }

    public void testAddModel() {
        this.model.register(this.SL);
        Model model = TestModelEvents.modelWithStatements("NT beats S; S beats H; H beats D");
        this.model.add(model);
        this.SL.assertHas(new Object[]{"addModel", model});
    }

    public void testDeleteModel() {
        this.model.register(this.SL);
        Model model = TestModelEvents.modelWithStatements("NT beats S; S beats H; H beats D");
        this.model.remove(model);
        this.SL.assertHas(new Object[]{"removeModel", model});
    }

    public void testNullListener() {
        NullListener nullListener = new NullListener();
        this.model.register(nullListener);
        this.model.add(TestModelEvents.statement(this.model, "S P O "));
        this.model.remove(TestModelEvents.statement(this.model, "X Y Z"));
        this.model.add(TestModelEvents.statements(this.model, "a B c; d E f"));
        this.model.remove(TestModelEvents.statements(this.model, "g H i; j K l"));
        this.model.add(this.asIterator(TestModelEvents.statements(this.model, "m N o; p Q r")));
        this.model.remove(this.asIterator(TestModelEvents.statements(this.model, "s T u; v W x")));
        this.model.add(TestModelEvents.modelWithStatements("leaves fall softly"));
        this.model.remove(TestModelEvents.modelWithStatements("water drips endlessly"));
        this.model.add(Arrays.asList(TestModelEvents.statements(this.model, "xx RR yy")));
        this.model.remove(Arrays.asList(TestModelEvents.statements(this.model, "aa VV rr")));
    }

    public void testChangedListener() {
        ChangedListener changedListener = new ChangedListener();
        this.model.register(changedListener);
        TestModelEvents.assertFalse((boolean)changedListener.hasChanged());
        this.model.add(TestModelEvents.statement(this.model, "S P O"));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        TestModelEvents.assertFalse((boolean)changedListener.hasChanged());
        this.model.remove(TestModelEvents.statement(this.model, "ab CD ef"));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        this.model.add(TestModelEvents.statements(this.model, "gh IJ kl"));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        this.model.remove(TestModelEvents.statements(this.model, "mn OP qr"));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        this.model.add(this.asIterator(TestModelEvents.statements(this.model, "st UV wx")));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        TestModelEvents.assertFalse((boolean)changedListener.hasChanged());
        this.model.remove(this.asIterator(TestModelEvents.statements(this.model, "yz AB cd")));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        this.model.add(TestModelEvents.modelWithStatements("ef GH ij"));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        this.model.remove(TestModelEvents.modelWithStatements("kl MN op"));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        this.model.add(Arrays.asList(TestModelEvents.statements(this.model, "rs TU vw")));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
        this.model.remove(Arrays.asList(TestModelEvents.statements(this.model, "xy wh q")));
        TestModelEvents.assertTrue((boolean)changedListener.hasChanged());
    }

    public void testGeneralEvent() {
        this.model.register(this.SL);
        int[] nArray = new int[]{};
        this.model.notifyEvent(nArray);
        this.SL.assertHas(new Object[]{"someEvent", this.model, nArray});
    }

    public void another(Map map, Object object) {
        Integer n = (Integer)map.get(object);
        if (n == null) {
            n = new Integer(0);
        }
        map.put(object, new Integer(n + 1));
    }

    public Map asBag(List list) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            this.another(hashMap, list.get(i));
        }
        return hashMap;
    }

    public void assertSameBag(List list, List list2) {
        TestModelEvents.assertEquals((Object)this.asBag(list), (Object)this.asBag(list2));
    }

    public void testGot(WatchStatementListener watchStatementListener, String string, String string2) {
        this.assertSameBag(Arrays.asList(TestModelEvents.statements(this.model, string2)), watchStatementListener.contents());
        TestModelEvents.assertEquals((String)string, (String)watchStatementListener.getAddOrRem());
        TestModelEvents.assertTrue((watchStatementListener.contents().size() == 0 ? 1 : 0) != 0);
    }

    public void testTripleListener() {
        WatchStatementListener watchStatementListener = new WatchStatementListener();
        this.model.register(watchStatementListener);
        this.model.add(TestModelEvents.statement(this.model, "b C d"));
        this.testGot(watchStatementListener, "add", "b C d");
        this.model.remove(TestModelEvents.statement(this.model, "e F g"));
        this.testGot(watchStatementListener, "rem", "e F g");
        this.model.add(TestModelEvents.statements(this.model, "h I j; k L m"));
        this.testGot(watchStatementListener, "add", "h I j; k L m");
        this.model.remove(TestModelEvents.statements(this.model, "n O p; q R s"));
        this.testGot(watchStatementListener, "rem", "n O p; q R s");
        this.model.add(Arrays.asList(TestModelEvents.statements(this.model, "t U v; w X y")));
        this.testGot(watchStatementListener, "add", "t U v; w X y");
        this.model.remove(Arrays.asList(TestModelEvents.statements(this.model, "z A b; c D e")));
        this.testGot(watchStatementListener, "rem", "z A b; c D e");
        this.model.add(this.asIterator(TestModelEvents.statements(this.model, "f G h; i J k")));
        this.testGot(watchStatementListener, "add", "f G h; i J k");
        this.model.remove(this.asIterator(TestModelEvents.statements(this.model, "l M n; o P q")));
        this.testGot(watchStatementListener, "rem", "l M n; o P q");
        this.model.add(TestModelEvents.modelWithStatements("r S t; u V w; x Y z"));
        this.testGot(watchStatementListener, "add", "r S t; u V w; x Y z");
        this.model.remove(TestModelEvents.modelWithStatements("a E i; o U y"));
        this.testGot(watchStatementListener, "rem", "a E i; o U y");
    }

    public void testObjectListener() {
        OL oL = new OL();
        this.model.register(oL);
        Statement statement = TestModelEvents.statement(this.model, "aa BB cc");
        Statement statement2 = TestModelEvents.statement(this.model, "dd EE ff");
        this.model.add(statement);
        oL.recent("add", statement);
        this.model.remove(statement2);
        oL.recent("rem", statement2);
        List<Statement> list = Arrays.asList(TestModelEvents.statements(this.model, "gg HH ii; jj KK ll"));
        this.model.add(list);
        oL.recent("add", list);
        List<Statement> list2 = Arrays.asList(TestModelEvents.statements(this.model, "mm NN oo; pp QQ rr; ss TT uu"));
        this.model.remove(list2);
        oL.recent("rem", list2);
        Model model = TestModelEvents.modelWithStatements("vv WW xx; yy ZZ aa");
        this.model.add(model);
        oL.recent("add", model);
        Model model2 = TestModelEvents.modelWithStatements("a B g; d E z");
        this.model.remove(model2);
        oL.recent("rem", model2);
        Statement[] statementArray = TestModelEvents.statements(this.model, "th i k; l m n");
        this.model.add(statementArray);
        oL.recent("add", statementArray);
        Statement[] statementArray2 = TestModelEvents.statements(this.model, "x o p; r u ch");
        this.model.remove(statementArray2);
        oL.recent("rem", statementArray2);
        Statement[] statementArray3 = TestModelEvents.statements(this.model, "u ph ch; psi om eh");
        this.model.add(this.asIterator(statementArray3));
        oL.recent("add", this.asIterator(statementArray3));
        Statement[] statementArray4 = TestModelEvents.statements(this.model, "at last the; end of these; tests ok guv");
        this.model.remove(this.asIterator(statementArray4));
        oL.recent("rem", this.asIterator(statementArray4));
    }

    static class OL
    extends ObjectListener {
        private Object recorded;
        private String how;

        OL() {
        }

        public void added(Object object) {
            this.recorded = object;
            this.how = "add";
        }

        public void removed(Object object) {
            this.recorded = object;
            this.how = "rem";
        }

        private Object comparable(Object object) {
            if (object instanceof Statement[]) {
                return Arrays.asList((Statement[])object);
            }
            if (object instanceof Iterator) {
                return GraphTestBase.iteratorToList((Iterator)object);
            }
            return object;
        }

        public void recent(String string, Object object) {
            Assert.assertEquals((Object)this.comparable(object), (Object)this.comparable(this.recorded));
            Assert.assertEquals((String)string, (String)this.how);
            this.how = null;
            this.recorded = null;
        }
    }

    public static class WatchStatementListener
    extends StatementListener {
        List statements = new ArrayList();
        String addOrRem = "<unset>";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List contents() {
            try {
                List list = this.statements;
                return list;
            }
            finally {
                this.statements = new ArrayList();
            }
        }

        public String getAddOrRem() {
            return this.addOrRem;
        }

        public void addedStatement(Statement statement) {
            this.statements.add(statement);
            this.addOrRem = "add";
        }

        public void removedStatement(Statement statement) {
            this.statements.add(statement);
            this.addOrRem = "rem";
        }
    }
}

