/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleReasoner;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoReasonerSuppliedException;
import com.hp.hpl.jena.shared.NoSuchReasonerException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.RulesetNotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestModelSpecRevised
extends ModelTestBase {
    public static final Resource A = TestModelSpecRevised.resource("_a");

    public TestModelSpecRevised(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpecRevised.class);
    }

    public void testTriples() {
        this.check("a R b", "a R b", new Object[0]);
        this.check("a R b", "a R ?0", new Object[]{"b"});
        this.check("a P b", "a ?0 ?1", new Object[]{"P", "b"});
        this.check("_a P 17; Q P _a", "?0 ?1 ?2; ?3 ?1 ?0", new Object[]{"_a", "P", "17", "Q"});
    }

    public void check(String string, String string2, Object[] objectArray) {
        Model model = TestModelSpecRevised.modelWithStatements(string2, objectArray);
        this.assertIsoModels(TestModelSpecRevised.modelWithStatements(string), model);
    }

    private static Model modelWithStatements(String string, Object[] objectArray) {
        GraphMem graphMem = new GraphMem();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            graphMem.add(TestModelSpecRevised.replace(TestModelSpecRevised.triple(PrefixMapping.Extended, stringTokenizer.nextToken()), objectArray));
        }
        return ModelFactory.createModelForGraph(graphMem);
    }

    private static Triple replace(Triple triple, Object[] objectArray) {
        return Triple.create(TestModelSpecRevised.replace(triple.getSubject(), objectArray), TestModelSpecRevised.replace(triple.getPredicate(), objectArray), TestModelSpecRevised.replace(triple.getObject(), objectArray));
    }

    private static Node replace(Node node, Object[] objectArray) {
        String string;
        if (node.isVariable() && Character.isDigit((string = node.getName()).charAt(0))) {
            return Node.create((String)objectArray[Integer.parseInt(string)]);
        }
        return node;
    }

    protected static void assertSameRules(List list, List list2) {
        TestModelSpecRevised.assertEquals(new HashSet(list), new HashSet(list2));
    }

    public void testNoReasonerSuppliedException() {
        Model model = TestModelSpecRevised.modelWithStatements("_a rdf:type jms:ReasonerSpec");
        Resource resource = TestModelSpecRevised.resource("_a");
        try {
            InfModelSpec.getReasonerFactory(resource, model);
            TestModelSpecRevised.fail((String)"should catch missing reasoner");
        }
        catch (NoReasonerSuppliedException noReasonerSuppliedException) {
            TestModelSpecRevised.pass();
        }
    }

    public void testNoSuchReasonerException() {
        Model model = TestModelSpecRevised.modelWithStatements("_a rdf:type jms:ReasonerSpec; _a jms:reasoner nosuch:reasoner");
        Resource resource = TestModelSpecRevised.resource("_a");
        try {
            InfModelSpec.getReasonerFactory(resource, model);
            TestModelSpecRevised.fail((String)"should catch unknown reasoner");
        }
        catch (NoSuchReasonerException noSuchReasonerException) {
            TestModelSpecRevised.assertEquals((String)"nosuch:reasoner", (String)noSuchReasonerException.getURI());
            this.assertContains("nosuch:reasoner", noSuchReasonerException.toString());
        }
    }

    public void testGetOWLFBReasoner() {
        this.testGetReasoner("http://jena.hpl.hp.com/2003/OWLFBRuleReasoner", OWLFBRuleReasoner.class);
    }

    public void testGetRDFSRuleReasoner() {
        this.testGetReasoner("http://jena.hpl.hp.com/2003/RDFSExptRuleReasoner", RDFSRuleReasoner.class);
    }

    public void testRulesetURLFails() {
        String string = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        Model model = TestModelSpecRevised.modelWithStatements("_a jms:reasoner ?0; _a jms:ruleSetURL nowhere:man", new Object[]{string});
        try {
            InfModelSpec.getReasonerFactory(A, model).create(null);
            TestModelSpecRevised.fail((String)"should report ruleset failure");
        }
        catch (RulesetNotFoundException rulesetNotFoundException) {
            TestModelSpecRevised.assertEquals((String)"nowhere:man", (String)rulesetNotFoundException.getURI());
        }
    }

    public void testEmptyRulesetURLWorks() {
        this.testRuleSetURL("http://jena.hpl.hp.com/2003/GenericRuleReasoner", TestModelSpecRevised.file("empty.rules"));
    }

    public void testNonEmptyRulesetURLWorks() {
        this.testRuleSetURL("http://jena.hpl.hp.com/2003/GenericRuleReasoner", TestModelSpecRevised.file("example.rules"));
    }

    public void testMultipleRulesetURLsWork() {
        String string = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        String string2 = TestModelSpecRevised.file("example.rules");
        String string3 = TestModelSpecRevised.file("extra.rules");
        List list = this.append(Rule.rulesFromURL(string2), Rule.rulesFromURL(string3));
        Model model = TestModelSpecRevised.modelWithStatements("_a jms:reasoner ?0; _a jms:ruleSetURL ?1; _a jms:ruleSetURL ?2", new Object[]{string, string2, string3});
        ReasonerFactory reasonerFactory = InfModelSpec.getReasonerFactory(A, model);
        RuleReasoner ruleReasoner = (RuleReasoner)reasonerFactory.create(null);
        TestModelSpecRevised.assertSameRules(list, ruleReasoner.getRules());
    }

    public void testInlineRulesets() {
        String string = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        String string2 = "[rdfs2:  (?x ?p ?y), (?p rdfs:domain ?c) -> (?x rdf:type ?c)]";
        String string3 = "[rdfs9:  (?x rdfs:subClassOf ?y), (?a rdf:type ?x) -> (?a rdf:type ?y)]";
        List list = this.append(Rule.parseRules(string2), Rule.parseRules(string3));
        Model model = this.rSpec(string).add(A, JenaModelSpec.ruleSet, TestModelSpecRevised.resource("onward:rules")).add(TestModelSpecRevised.resource("onward:rules"), JenaModelSpec.hasRule, string2).add(TestModelSpecRevised.resource("onward:rules"), JenaModelSpec.hasRule, string3);
        ReasonerFactory reasonerFactory = InfModelSpec.getReasonerFactory(A, model);
        RuleReasoner ruleReasoner = (RuleReasoner)reasonerFactory.create(null);
        TestModelSpecRevised.assertSameRules(list, ruleReasoner.getRules());
    }

    public void testURLRulesets() {
        String string = "http://jena.hpl.hp.com/2003/GenericRuleReasoner";
        String string2 = TestModelSpecRevised.file("example.rules");
        String string3 = TestModelSpecRevised.file("extra.rules");
        List list = this.append(Rule.rulesFromURL(string2), Rule.rulesFromURL(string3));
        Model model = this.rSpec(string).add(A, JenaModelSpec.ruleSet, TestModelSpecRevised.resource("onward:rules")).add(TestModelSpecRevised.resource("onward:rules"), JenaModelSpec.ruleSetURL, TestModelSpecRevised.resource(string2)).add(TestModelSpecRevised.resource("onward:rules"), JenaModelSpec.ruleSetURL, TestModelSpecRevised.resource(string3));
        ReasonerFactory reasonerFactory = InfModelSpec.getReasonerFactory(A, model);
        RuleReasoner ruleReasoner = (RuleReasoner)reasonerFactory.create(null);
        TestModelSpecRevised.assertSameRules(list, ruleReasoner.getRules());
    }

    public void testSchema() {
        ReasonerRegistry.theRegistry().register("fake:factory", new FakeFactory());
        String string = "_root jms:reasonsWith _reasoner; _reasoner jms:reasoner fake:factory; _root jms:maker _maker; _maker rdf:type jms:MemMakerSpec; _maker jms:reificationMode jms:rsMinimal; _reasoner jms:schemaURL ?0; _reasoner jms:schemaURL ?1";
        Model model = TestModelSpecRevised.modelWithStatements(string, new Object[]{TestModelSpecRevised.file("schema.n3"), TestModelSpecRevised.file("schema2.n3")});
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        this.validateHasSchema(this.loadBoth("schema.n3", "schema2.n3"), modelSpec.createModel());
    }

    private Graph loadBoth(String string, String string2) {
        Model model = FileManager.get().loadModel(TestModelSpecRevised.file(string));
        Model model2 = FileManager.get().loadModel(TestModelSpecRevised.file(string2));
        model.add(model2);
        return model.getGraph();
    }

    private void validateHasSchema(Graph graph, Model model) {
        ((FakeReasoner)((InfGraph)model.getGraph()).getReasoner()).validate(graph);
    }

    public void testCreateReasoningModel() {
        String string = "[rdfs3a: (?x rdfs:range  ?y), (?y rdfs:subClassOf ?z) -> (?x rdfs:range  ?z)]";
        List list = Rule.parseRules(string);
        ModelSpec modelSpec = this.createInfModelSpec(string);
        Model model = modelSpec.createModel();
        Graph graph = model.getGraph();
        TestModelSpecRevised.assertTrue((boolean)(graph instanceof InfGraph));
        Reasoner reasoner = ((InfGraph)graph).getReasoner();
        TestModelSpecRevised.assertTrue((boolean)(reasoner instanceof RuleReasoner));
        RuleReasoner ruleReasoner = (RuleReasoner)reasoner;
        List list2 = ruleReasoner.getRules();
        TestModelSpecRevised.assertSameRules(list, list2);
    }

    public void testDescription() {
        String string = "[rdfs3a: (?x rdfs:range  ?y), (?y rdfs:subClassOf ?z) -> (?x rdfs:range  ?z)]";
        Model model = TestModelSpecRevised.createInfModelDesc(A, "http://jena.hpl.hp.com/2003/GenericRuleReasoner", string);
        ModelSpec modelSpec = ModelSpecFactory.createSpec(model);
        this.assertIsoModels(model, modelSpec.getDescription());
    }

    private ModelSpec createInfModelSpec(String string) {
        Model model = TestModelSpecRevised.createInfModelDesc(A, "http://jena.hpl.hp.com/2003/GenericRuleReasoner", string);
        return ModelSpecFactory.createSpec(model);
    }

    public static Model createInfModelDesc(Resource resource, String string, String string2) {
        String string3 = "_root jms:reasonsWith _reasoner; _reasoner jms:reasoner ?0; _root jms:maker _maker; _maker rdf:type jms:MemMakerSpec; _maker jms:reificationMode jms:rsMinimal; _reasoner jms:ruleSet _rules; _rules jms:hasRule ?1";
        return TestModelSpecRevised.modelWithStatements(string3, new Object[]{string, "'" + string2 + "'"});
    }

    private void testRuleSetURL(String string, String string2) {
        List list = Rule.rulesFromURL(string2);
        Model model = TestModelSpecRevised.modelWithStatements("_a jms:reasoner ?0; _a jms:ruleSetURL ?1", new Object[]{string, string2});
        ReasonerFactory reasonerFactory = InfModelSpec.getReasonerFactory(A, model);
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)reasonerFactory.create(null);
        TestModelSpecRevised.assertSameRules(list, genericRuleReasoner.getRules());
    }

    protected void testGetReasoner(String string, Class clazz) {
        ReasonerFactory reasonerFactory = InfModelSpec.getReasonerFactory(A, this.rSpec(string));
        TestModelSpecRevised.assertEquals((Object)clazz, reasonerFactory.create(null).getClass());
    }

    protected Model rSpec(String string) {
        return TestModelSpecRevised.modelWithStatements("_a jms:reasoner " + string);
    }

    protected static String file(String string) {
        return "file:testing/modelspecs/" + string;
    }

    protected void assertContains(String string, String string2) {
        if (string2 == null) {
            TestModelSpecRevised.fail((String)("<null> does not contain anything, especially '" + string + "'"));
        }
        if (string2.indexOf(string) < 0) {
            TestModelSpecRevised.fail((String)("'" + string2 + "' does not contain '" + string + "'"));
        }
    }

    protected static class FakeFactory
    implements ReasonerFactory {
        protected FakeFactory() {
        }

        public Reasoner create(Resource resource) {
            return new FakeReasoner();
        }

        public Model getCapabilities() {
            return null;
        }

        public String getURI() {
            return null;
        }
    }

    protected static class FakeReasoner
    implements Reasoner {
        public Graph bound = new GraphMem();

        protected FakeReasoner() {
        }

        public void validate(Graph graph) {
            Assert.assertTrue((String)"bound graph is not correct", (boolean)graph.isIsomorphicWith(this.bound));
        }

        public Reasoner bindSchema(Graph graph) throws ReasonerException {
            this.bound.getBulkUpdateHandler().add(graph);
            return this;
        }

        public Reasoner bindSchema(Model model) throws ReasonerException {
            return this.bindSchema(model.getGraph());
        }

        public InfGraph bind(Graph graph) throws ReasonerException {
            return new BasicForwardRuleInfGraph(this, new ArrayList(), new GraphMem(), new GraphMem());
        }

        public void setDerivationLogging(boolean bl) {
            throw new JenaException("fakes don't do this");
        }

        public void setParameter(Property property, Object object) {
            throw new JenaException("fakes don't do this");
        }

        public Model getReasonerCapabilities() {
            throw new JenaException("fakes don't do this");
        }

        public void addDescription(Model model, Resource resource) {
            throw new JenaException("fakes don't do this");
        }

        public boolean supportsProperty(Property property) {
            throw new JenaException("fakes don't do this");
        }

        public Capabilities getGraphCapabilities() {
            return new BaseInfGraph.InfCapabilities();
        }
    }
}

