/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.Var;
import com.hp.hpl.jena.rdql.parser.Node;
import com.hp.hpl.jena.rdql.parser.ParsedLiteral;
import com.hp.hpl.jena.rdql.parser.Q_ConstraintClause;
import com.hp.hpl.jena.rdql.parser.Q_Identifier;
import com.hp.hpl.jena.rdql.parser.Q_PrefixDecl;
import com.hp.hpl.jena.rdql.parser.Q_PrefixesClause;
import com.hp.hpl.jena.rdql.parser.Q_SelectClause;
import com.hp.hpl.jena.rdql.parser.Q_SourceClause;
import com.hp.hpl.jena.rdql.parser.Q_TriplePattern;
import com.hp.hpl.jena.rdql.parser.Q_TriplePatternClause;
import com.hp.hpl.jena.rdql.parser.Q_URI;
import com.hp.hpl.jena.rdql.parser.Q_URL;
import com.hp.hpl.jena.rdql.parser.Q_Var;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.SimpleNode;
import java.util.Iterator;
import java.util.List;

public class Q_Query
extends SimpleNode {
    private Query query = null;
    boolean selectAllVars = false;

    public Q_Query(int n) {
        super(n);
    }

    public Q_Query(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void phase2(Query query) {
        this.query = query;
        try {
            int n;
            int n2 = this.jjtGetNumChildren();
            for (n = 0; n < n2; ++n) {
                Node node = this.jjtGetChild(n);
                if (!(node instanceof Q_PrefixesClause)) continue;
                this.extractPrefixes(query, (Q_PrefixesClause)node);
            }
            this.postParse(query);
            n = 0;
            if (!(this.jjtGetChild(n) instanceof Q_SelectClause)) {
                throw new RDQL_InternalErrorException("Parser didn't catch absense of select clause");
            }
            this.extractVarList(query, this.jjtGetChild(n));
            if (this.jjtGetChild(++n) instanceof Q_SourceClause) {
                int n4 = this.jjtGetChild(n).jjtGetNumChildren();
                if (n4 > 1) {
                    throw new QueryException("Error: Multiple sources in FROM clause");
                }
                for (int i = 0; i < n4; ++i) {
                    Node node = this.jjtGetChild(n).jjtGetChild(i).jjtGetChild(0);
                    String string = ((Q_URL)node).urlString;
                    if (i != 0) continue;
                    query.setSourceURL(string);
                }
                ++n;
            }
            if (!(this.jjtGetChild(n) instanceof Q_TriplePatternClause)) {
                throw new RDQL_InternalErrorException("Parser didn't catch absense of triple patterns");
            }
            this.extractTriplePatternsFP(query, this.jjtGetChild(n));
            if (++n < n2 && this.jjtGetChild(n) instanceof Q_ConstraintClause) {
                this.extractConstraints(query, this.jjtGetChild(n));
                ++n;
            }
        }
        catch (RDQL_InternalErrorException rDQL_InternalErrorException) {
            throw rDQL_InternalErrorException;
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (ClassCastException classCastException) {
            throw new RDQL_InternalErrorException("Parser generated illegal parse tree: " + classCastException);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RDQL_InternalErrorException("Unknown exception: " + exception);
        }
    }

    public String toString() {
        throw new UnsupportedOperationException("Q_Query.toString()");
    }

    private void extractVarList(Query query, Node node) {
        int n = node.jjtGetNumChildren();
        this.selectAllVars = n == 0;
        for (int i = 0; i < n; ++i) {
            Node node2 = node.jjtGetChild(i);
            if (!(node2 instanceof Q_Var)) {
                throw new RDQL_InternalErrorException("Internal error: parser created '" + node2.getClass().getName() + "' when Q_Var expected");
            }
            Q_Var q_Var = (Q_Var)node2;
            query.addResultVar(q_Var.varName);
        }
    }

    private void extractTriplePatternsFP(Query query, Node node) {
        Object object;
        Q_TriplePatternClause q_TriplePatternClause = (Q_TriplePatternClause)node;
        List list = query.getBoundVars();
        int n = q_TriplePatternClause.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            object = (Q_TriplePattern)q_TriplePatternClause.jjtGetChild(i);
            if (((SimpleNode)object).jjtGetNumChildren() != 3) {
                throw new RDQL_InternalErrorException("Triple pattern has " + ((SimpleNode)object).jjtGetNumChildren() + " children");
            }
            com.hp.hpl.jena.graph.Node node2 = Q_Query.convertToGraphNode(((SimpleNode)object).jjtGetChild(0), query);
            com.hp.hpl.jena.graph.Node node3 = Q_Query.convertToGraphNode(((SimpleNode)object).jjtGetChild(1), query);
            com.hp.hpl.jena.graph.Node node4 = Q_Query.convertToGraphNode(((SimpleNode)object).jjtGetChild(2), query);
            query.addTriplePattern(node2, node3, node4);
        }
        if (this.selectAllVars) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                query.addResultVar((String)object);
            }
        }
    }

    private static com.hp.hpl.jena.graph.Node convertToGraphNode(Node node, Query query) {
        if (node instanceof Var) {
            String string = ((Var)((Object)node)).getVarName();
            query.addBoundVar(string);
            return com.hp.hpl.jena.graph.Node.createVariable(((Var)((Object)node)).getVarName());
        }
        if (node instanceof ParsedLiteral) {
            ParsedLiteral parsedLiteral = (ParsedLiteral)node;
            if (parsedLiteral.isNode()) {
                return parsedLiteral.getNode();
            }
            if (parsedLiteral.isURI()) {
                return com.hp.hpl.jena.graph.Node.createURI(parsedLiteral.getURI());
            }
            if (parsedLiteral.isString()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(parsedLiteral.getString(), null, null);
            }
            if (parsedLiteral.isBoolean()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(parsedLiteral.asUnquotedString(), null, null);
            }
            if (parsedLiteral.isInt()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(parsedLiteral.asUnquotedString(), null, XSDDatatype.XSDinteger);
            }
            if (parsedLiteral.isDouble()) {
                return com.hp.hpl.jena.graph.Node.createLiteral(parsedLiteral.asUnquotedString(), null, XSDDatatype.XSDdouble);
            }
            String string = parsedLiteral.getString();
            System.err.println("BUG: " + string);
        }
        throw new RDQL_InternalErrorException("convertToGraphNode encountered strange type: " + node.getClass().getName());
    }

    private void extractConstraints(Query query, Node node) {
        Q_ConstraintClause q_ConstraintClause = (Q_ConstraintClause)node;
        int n = q_ConstraintClause.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node2 = q_ConstraintClause.jjtGetChild(i);
            if (!(node2 instanceof Constraint)) {
                throw new RDQL_InternalErrorException("Parse node in AND clause isn't a Constraint");
            }
            query.addConstraint((Constraint)((Object)node2));
        }
    }

    private void extractPrefixes(Query query, Q_PrefixesClause q_PrefixesClause) {
        if (q_PrefixesClause == null) {
            return;
        }
        int n = q_PrefixesClause.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Q_PrefixDecl q_PrefixDecl = (Q_PrefixDecl)q_PrefixesClause.jjtGetChild(i);
            for (int j = 0; j < q_PrefixDecl.jjtGetNumChildren(); j += 2) {
                Q_Identifier q_Identifier = (Q_Identifier)q_PrefixDecl.jjtGetChild(j);
                Q_URI q_URI = (Q_URI)q_PrefixDecl.jjtGetChild(j + 1);
                this.query.setPrefix(q_Identifier.toString(), q_URI.toString());
            }
        }
    }
}

