/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Variable;

public class Node_RuleVariable
extends Node_Variable {
    protected int index;
    protected Node value;
    protected boolean isRef = true;
    public static final Node_RuleVariable WILD = new Node_RuleVariable("*", -1);

    public Node_RuleVariable(String string, int n) {
        super(new VarLabel(string));
        this.index = n;
        this.value = this;
    }

    private Node_RuleVariable(VarLabel varLabel, int n) {
        super(varLabel);
        this.index = n;
        this.value = this;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void simpleBind(Node node) {
        this.value = node;
        this.isRef = node instanceof Node_RuleVariable;
    }

    public Node deref() {
        Node_RuleVariable node_RuleVariable = this;
        while (node_RuleVariable.isRef) {
            if (node_RuleVariable.value == node_RuleVariable) {
                return node_RuleVariable;
            }
            node_RuleVariable = (Node_RuleVariable)node_RuleVariable.value;
        }
        return node_RuleVariable.value;
    }

    public Node getRawBoundValue() {
        return this.value;
    }

    public void unbind() {
        this.isRef = true;
        this.value = this;
    }

    public boolean isUnbound() {
        return this.isRef && this.value == this;
    }

    public Node_RuleVariable cloneNode() {
        return new Node_RuleVariable((VarLabel)this.label, this.index);
    }

    public String toString() {
        String string = ((VarLabel)this.label).getLabel();
        return string == null ? "*" : string;
    }

    public boolean sameValueAs(Object object) {
        return object instanceof Node_RuleVariable;
    }

    public static boolean sameNodeAs(Node node, Node node2) {
        if (node instanceof Node_RuleVariable) {
            if (node2 instanceof Node_RuleVariable) {
                return ((Node_RuleVariable)node).getIndex() == ((Node_RuleVariable)node2).getIndex();
            }
            return false;
        }
        return node.sameValueAs(node2);
    }

    static class VarLabel {
        String label;

        VarLabel(String string) {
            this.label = string;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

