/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.RDFSCMPPreprocessHook;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RDFSRuleReasoner
extends GenericRuleReasoner {
    public static final String DEFAULT_RULES = "default";
    public static final String FULL_RULES = "full";
    public static final String SIMPLE_RULES = "simple";
    protected static final String RULE_FILE = "etc/rdfs-fb-tgc-noresource.rules";
    protected static final String FULL_RULE_FILE = "etc/rdfs-fb-tgc.rules";
    protected static final String SIMPLE_RULE_FILE = "etc/rdfs-fb-tgc-simple.rules";
    protected static HashMap ruleSets = new HashMap();
    protected static HashMap ruleFiles;
    protected static RulePreprocessHook cmpProcessor;

    public RDFSRuleReasoner(ReasonerFactory reasonerFactory) {
        super(RDFSRuleReasoner.loadRulesLevel(DEFAULT_RULES), reasonerFactory);
        this.setMode(HYBRID);
        this.setTransitiveClosureCaching(true);
    }

    public RDFSRuleReasoner(ReasonerFactory reasonerFactory, Resource resource) {
        this(reasonerFactory);
        if (resource != null) {
            StmtIterator stmtIterator = resource.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                this.doSetParameter(statement.getPredicate(), ((Object)statement.getObject()).toString());
            }
        }
    }

    protected RDFSRuleReasoner(FBRuleInfGraph fBRuleInfGraph, ReasonerFactory reasonerFactory) {
        super(fBRuleInfGraph.getRules(), reasonerFactory);
        this.schemaGraph = fBRuleInfGraph;
    }

    protected boolean doSetParameter(Property property, Object object) {
        if (property.equals(ReasonerVocabulary.PROPenableCMPScan)) {
            boolean bl = Util.convertBooleanPredicateArg(property, object);
            if (bl) {
                this.addPreprocessingHook(cmpProcessor);
            } else {
                this.removePreprocessingHook(cmpProcessor);
            }
            return true;
        }
        if (property.equals(ReasonerVocabulary.PROPsetRDFSLevel)) {
            String string = ((String)object).toLowerCase();
            this.setRules(RDFSRuleReasoner.loadRulesLevel(string));
            if (string.equals(FULL_RULES)) {
                this.addPreprocessingHook(cmpProcessor);
            } else {
                this.removePreprocessingHook(cmpProcessor);
            }
            return true;
        }
        return super.doSetParameter(property, object);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        RDFSRuleInfGraph rDFSRuleInfGraph;
        Graph graph2 = this.schemaGraph == null ? this.getPreload() : this.schemaGraph;
        RDFSRuleInfGraph rDFSRuleInfGraph2 = null;
        List list = ((FBRuleInfGraph)graph2).getRules();
        rDFSRuleInfGraph2 = rDFSRuleInfGraph = new RDFSRuleInfGraph(this, list, graph2);
        if (this.enableTGCCaching) {
            rDFSRuleInfGraph.setUseTGCCache();
        }
        rDFSRuleInfGraph.setTraceOn(this.traceOn);
        if (this.preprocessorHooks != null) {
            Iterator iterator = this.preprocessorHooks.iterator();
            while (iterator.hasNext()) {
                rDFSRuleInfGraph.addPreprocessingHook((RulePreprocessHook)iterator.next());
            }
        }
        rDFSRuleInfGraph2.setDerivationLogging(this.recordDerivations);
        rDFSRuleInfGraph2.rebind(graph);
        return rDFSRuleInfGraph2;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an RDFSRuleReasoner");
        }
        FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this, this.rules, this.getPreload(), graph);
        if (this.enableTGCCaching) {
            fBRuleInfGraph.setUseTGCCache();
        }
        fBRuleInfGraph.prepare();
        RDFSRuleReasoner rDFSRuleReasoner = new RDFSRuleReasoner(fBRuleInfGraph, this.factory);
        rDFSRuleReasoner.setDerivationLogging(this.recordDerivations);
        rDFSRuleReasoner.setTraceOn(this.traceOn);
        rDFSRuleReasoner.setTransitiveClosureCaching(this.enableTGCCaching);
        rDFSRuleReasoner.setFunctorFiltering(this.filterFunctors);
        if (this.preprocessorHooks != null) {
            Iterator iterator = this.preprocessorHooks.iterator();
            while (iterator.hasNext()) {
                rDFSRuleReasoner.addPreprocessingHook((RulePreprocessHook)iterator.next());
            }
        }
        return rDFSRuleReasoner;
    }

    public static List loadRulesLevel(String string) {
        List list = (List)ruleSets.get(string);
        if (list == null) {
            String string2 = (String)ruleFiles.get(string);
            if (string2 == null) {
                throw new ReasonerException("Illegal RDFS conformance level: " + string);
            }
            list = RDFSRuleReasoner.loadRules(string2);
            ruleSets.put(string, list);
        }
        return list;
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }

    static {
        cmpProcessor = new RDFSCMPPreprocessHook();
        ruleFiles = new HashMap();
        ruleFiles.put(DEFAULT_RULES, RULE_FILE);
        ruleFiles.put(FULL_RULES, FULL_RULE_FILE);
        ruleFiles.put(SIMPLE_RULES, SIMPLE_RULE_FILE);
    }
}

