/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.vocabulary.RDF;

public class ListLength
extends BaseBuiltin {
    public String getName() {
        return "listLength";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] nodeArray, int n, RuleContext ruleContext) {
        this.checkArgs(n, ruleContext);
        BindingEnvironment bindingEnvironment = ruleContext.getEnv();
        int n2 = ListLength.getLength(this.getArg(0, nodeArray, ruleContext), ruleContext);
        if (n2 == -1) {
            return false;
        }
        bindingEnvironment.bind(nodeArray[1], Util.makeIntNode(n2));
        return true;
    }

    protected static int getLength(Node node, RuleContext ruleContext) {
        if (node.equals(RDF.Nodes.nil)) {
            return 0;
        }
        Node node2 = Util.getPropValue(node, RDF.Nodes.rest, ruleContext);
        if (node2 == null) {
            return -1;
        }
        int n = ListLength.getLength(node2, ruleContext);
        if (n == -1) {
            return -1;
        }
        return 1 + n;
    }
}

