/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESinkNode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESourceNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RETEQueue
implements RETESinkNode,
RETESourceNode {
    protected HashMap queue = new HashMap();
    protected byte[] matchIndices;
    protected RETEQueue sibling;
    protected RETESinkNode continuation;

    public RETEQueue(byte[] byArray) {
        this.matchIndices = byArray;
    }

    public RETEQueue(List list) {
        int n = list.size();
        this.matchIndices = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.matchIndices[i] = (byte)((Number)list.get(i)).intValue();
        }
    }

    public void setSibling(RETEQueue rETEQueue) {
        this.sibling = rETEQueue;
    }

    public void setContinuation(RETESinkNode rETESinkNode) {
        this.continuation = rETESinkNode;
        if (this.sibling != null) {
            this.sibling.continuation = rETESinkNode;
        }
    }

    public void fire(BindingVector bindingVector, boolean bl) {
        Count count = (Count)this.queue.get(bindingVector);
        if (count == null) {
            if (!bl) {
                return;
            }
            this.queue.put(bindingVector, new Count(1));
        } else if (bl) {
            count.inc();
        } else {
            count.dec();
            if (count.getCount() == 0) {
                this.queue.remove(bindingVector);
            }
        }
        Iterator iterator = this.sibling.queue.keySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Node[] nodeArray = ((BindingVector)iterator.next()).getEnvironment();
            Node[] nodeArray2 = bindingVector.getEnvironment();
            boolean bl2 = true;
            for (int i = 0; i < this.matchIndices.length; ++i) {
                n = this.matchIndices[i];
                if (nodeArray[n].sameValueAs(nodeArray2[n])) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            Node[] nodeArray3 = new Node[nodeArray.length];
            for (n = 0; n < nodeArray.length; ++n) {
                Node node = nodeArray[n];
                nodeArray3[n] = node == null ? nodeArray2[n] : node;
            }
            BindingVector bindingVector2 = new BindingVector(nodeArray3);
            this.continuation.fire(bindingVector2, bl);
        }
    }

    public RETENode clone(Map map, RETERuleContext rETERuleContext) {
        RETEQueue rETEQueue = (RETEQueue)map.get(this);
        if (rETEQueue == null) {
            rETEQueue = new RETEQueue(this.matchIndices);
            map.put(this, rETEQueue);
            rETEQueue.setSibling((RETEQueue)this.sibling.clone(map, rETERuleContext));
            rETEQueue.setContinuation((RETESinkNode)this.continuation.clone(map, rETERuleContext));
            rETEQueue.queue.putAll(this.queue);
        }
        return rETEQueue;
    }

    protected static class Count {
        int count;

        public Count(int n) {
            this.count = n;
        }

        public int getCount() {
            return this.count;
        }

        public void inc() {
            ++this.count;
        }

        public void dec() {
            --this.count;
        }

        public void setCount(int n) {
            this.count = n;
        }
    }
}

