/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESinkNode;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RETETerminal
implements RETESinkNode {
    protected RETERuleContext context;
    protected static Log logger = LogFactory.getLog((Class)FRuleEngine.class);

    public RETETerminal(Rule rule, RETEEngine rETEEngine, ForwardRuleInfGraphI forwardRuleInfGraphI) {
        this.context = new RETERuleContext(forwardRuleInfGraphI, rETEEngine);
        this.context.rule = rule;
    }

    private RETETerminal(RETERuleContext rETERuleContext) {
        this.context = rETERuleContext;
    }

    public void setContext(RETEEngine rETEEngine, ForwardRuleInfGraphI forwardRuleInfGraphI) {
        Rule rule = this.context.getRule();
        this.context = new RETERuleContext(forwardRuleInfGraphI, rETEEngine);
        this.context.setRule(rule);
    }

    public void fire(BindingVector bindingVector, boolean bl) {
        ClauseEntry clauseEntry;
        int n;
        Object object;
        Rule rule = this.context.getRule();
        this.context.setEnv(bindingVector);
        for (int i = 0; i < rule.bodyLength(); ++i) {
            object = rule.getBodyElement(i);
            if (!(object instanceof Functor) || !(bl ? !((Functor)object).evalAsBodyClause(this.context) : !((Functor)object).safeEvalAsBodyClause(this.context))) continue;
            return;
        }
        ForwardRuleInfGraphI forwardRuleInfGraphI = (ForwardRuleInfGraphI)this.context.getGraph();
        if (forwardRuleInfGraphI.shouldTrace()) {
            logger.info((Object)("Fired rule: " + rule.toShortString()));
        }
        object = this.context.getEngine();
        ((RETEEngine)object).incRuleCount();
        ArrayList<Triple> arrayList = null;
        if (forwardRuleInfGraphI.shouldLogDerivations() && bl) {
            arrayList = new ArrayList<Triple>(rule.bodyLength());
            for (n = 0; n < rule.bodyLength(); ++n) {
                clauseEntry = rule.getBodyElement(n);
                if (!(clauseEntry instanceof TriplePattern)) continue;
                arrayList.add(bindingVector.instantiate((TriplePattern)clauseEntry));
            }
        }
        for (n = 0; n < rule.headLength(); ++n) {
            Object object2;
            clauseEntry = rule.getHeadElement(n);
            if (clauseEntry instanceof TriplePattern) {
                object2 = bindingVector.instantiate((TriplePattern)clauseEntry);
                if (((Triple)object2).getSubject().isLiteral()) continue;
                if (bl) {
                    if (this.context.contains((Triple)object2)) continue;
                    ((RETEEngine)object).addTriple((Triple)object2, true);
                    if (!forwardRuleInfGraphI.shouldLogDerivations()) continue;
                    forwardRuleInfGraphI.logDerivation((Triple)object2, new RuleDerivation(rule, (Triple)object2, arrayList, forwardRuleInfGraphI));
                    continue;
                }
                if (!this.context.contains((Triple)object2)) continue;
                ((RETEEngine)object).deleteTriple((Triple)object2, true);
                continue;
            }
            if (clauseEntry instanceof Functor && bl) {
                object2 = (Functor)clauseEntry;
                Builtin builtin = ((Functor)object2).getImplementor();
                if (builtin != null) {
                    builtin.headAction(((Functor)object2).getBoundArgs(bindingVector), ((Functor)object2).getArgLength(), this.context);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + ((Functor)object2).getName() + " in " + rule.toShortString());
            }
            if (!(clauseEntry instanceof Rule)) continue;
            object2 = (Rule)clauseEntry;
            if (((Rule)object2).isBackward()) {
                if (bl) {
                    forwardRuleInfGraphI.addBRule(((Rule)object2).instantiate(bindingVector));
                    continue;
                }
                forwardRuleInfGraphI.deleteBRule(((Rule)object2).instantiate(bindingVector));
                continue;
            }
            throw new ReasonerException("Found non-backward subrule : " + object2);
        }
    }

    public RETENode clone(Map map, RETERuleContext rETERuleContext) {
        RETETerminal rETETerminal = (RETETerminal)map.get(this);
        if (rETETerminal == null) {
            RETERuleContext rETERuleContext2 = new RETERuleContext((ForwardRuleInfGraphI)rETERuleContext.getGraph(), rETERuleContext.getEngine());
            rETERuleContext2.setRule(this.context.getRule());
            rETETerminal = new RETETerminal(rETERuleContext2);
            map.put(this, rETETerminal);
        }
        return rETETerminal;
    }
}

