/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLExptRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLWGTester;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestOWLRules
extends TestCase {
    protected String manifest;
    protected static boolean testForward = false;
    protected static boolean testExpt = false;
    protected static boolean enableTracing = false;
    protected static boolean printStats = false;

    public TestOWLRules(String string) {
        super(string);
        this.manifest = string;
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestOWLRules("SymmetricProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("SymmetricProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("FunctionalProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("FunctionalProperty/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("FunctionalProperty/Manifest003.rdf"));
        testSuite.addTest((Test)new TestOWLRules("InverseFunctionalProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("InverseFunctionalProperty/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("InverseFunctionalProperty/Manifest003.rdf"));
        testSuite.addTest((Test)new TestOWLRules("rdf-charmod-uris/Manifest.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I4.6/Manifest003.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.2/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.5/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.5/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.5/Manifest003.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.5/Manifest004.rdf"));
        testSuite.addTest((Test)new TestOWLRules("inverseOf/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("TransitiveProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentClass/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentClass/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentClass/Manifest003.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentClass/Manifest005.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentProperty/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentProperty/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentProperty/Manifest003.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.1/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.24/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.24/Manifest002-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentProperty/Manifest006.rdf"));
        testSuite.addTest((Test)new TestOWLRules("intersectionOf/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("differentFrom/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("disjointWith/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("disjointWith/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("AllDifferent/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("allValuesFrom/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("allValuesFrom/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("someValuesFrom/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("maxCardinality/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("maxCardinality/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("FunctionalProperty/Manifest005-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.24/Manifest004-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("cardinality/Manifest001-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("cardinality/Manifest002-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("cardinality/Manifest003-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("cardinality/Manifest004-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("I5.24/Manifest003-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("cardinality/Manifest005-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("cardinality/Manifest006-mod.rdf"));
        testSuite.addTest((Test)new TestOWLRules("equivalentClass/Manifest004.rdf"));
        testSuite.addTest((Test)new TestOWLRules("someValuesFrom/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("localtests/Manifest001.rdf"));
        testSuite.addTest((Test)new TestOWLRules("localtests/Manifest002.rdf"));
        testSuite.addTest((Test)new TestOWLRules("localtests/Manifest003.rdf"));
        testSuite.addTest((Test)new TestOWLRules("localtests/Manifest004.rdf"));
        testSuite.addTest((Test)new TestOWLRules("localtests/Manifest005.rdf"));
        testSuite.addTest((Test)new TestOWLRules("localtests/Manifest006.rdf"));
        return testSuite;
    }

    protected void runTest() throws IOException {
        if (testForward) {
            OWLWGTester oWLWGTester = new OWLWGTester(OWLRuleReasonerFactory.theInstance(), this, null);
            oWLWGTester.runTests(this.manifest, enableTracing, printStats);
        } else {
            ReasonerFactory reasonerFactory = testExpt ? OWLExptRuleReasonerFactory.theInstance() : OWLFBRuleReasonerFactory.theInstance();
            OWLWGTester oWLWGTester = new OWLWGTester(reasonerFactory, this, null);
            oWLWGTester.runTests(this.manifest, enableTracing, printStats);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "FunctionalProperty/Manifest002.rdf";
            ReasonerFactory reasonerFactory = OWLExptRuleReasonerFactory.theInstance();
            OWLWGTester oWLWGTester = new OWLWGTester(reasonerFactory, null, null);
            System.out.println("Start test ...");
            oWLWGTester.runTests(string, false, true);
            System.out.println("...end test\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class DelayTest
    extends TestCase {
        public DelayTest(String string) {
            super(string);
        }

        protected void runTest() throws InterruptedException {
            Thread.sleep(2000L);
            DelayTest.assertTrue((boolean)true);
        }
    }
}

