/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.wg;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.wg.LazyInputStream;
import com.hp.hpl.jena.shared.wg.LazyURLInputStream;
import com.hp.hpl.jena.shared.wg.LazyZipEntryInputStream;
import com.hp.hpl.jena.shared.wg.URI;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipFile;

public class TestInputStreamFactory {
    private final URI base;
    private final URI mapBase;
    private final ZipFile zip;
    private final String property;
    private String createMe = "error";

    public TestInputStreamFactory(URI uRI, URI uRI2) {
        this.base = uRI;
        this.mapBase = uRI2;
        this.zip = null;
        this.property = null;
    }

    public TestInputStreamFactory(URI uRI, ZipFile zipFile) {
        this.base = uRI;
        this.mapBase = null;
        this.zip = zipFile;
        this.property = null;
    }

    public TestInputStreamFactory(URI uRI, String string) {
        this.createMe = "new TestInputStreamFactory(URI.create(\"" + uRI.toString() + "\"),\"" + string + "\")";
        this.base = uRI;
        this.mapBase = null;
        this.zip = null;
        this.property = string.endsWith("/") ? string : string + "/";
    }

    public URI getBase() {
        return this.base;
    }

    public InputStream open(String string) {
        return this.open(URI.create(string));
    }

    public InputStream fullyOpen(String string) throws IOException {
        InputStream inputStream = this.open(URI.create(string));
        if (inputStream instanceof LazyInputStream && !((LazyInputStream)inputStream).connect()) {
            return null;
        }
        return inputStream;
    }

    public InputStream open(URI uRI) {
        return (InputStream)this.open(uRI, true);
    }

    public boolean savable() {
        return this.mapBase != null && this.mapBase.getScheme().equalsIgnoreCase("file");
    }

    public OutputStream openOutput(String string) {
        OutputStream outputStream = (OutputStream)this.open(URI.create(string), false);
        return outputStream;
    }

    public String getCreationJava() {
        return this.createMe;
    }

    private Object open(URI uRI, boolean bl) {
        URI uRI2;
        URI uRI3 = uRI2 = uRI.isAbsolute() ? this.base.relativize(uRI) : uRI;
        if (uRI2.isAbsolute()) {
            throw new IllegalArgumentException("This  TestInputStreamFactory only knows about '" + this.base + "'.");
        }
        String string = uRI2.toString();
        if (string.length() - string.lastIndexOf(46) > 5) {
            string = string + ".rdf";
            uRI2 = URI.create(string);
        }
        if (this.mapBase != null) {
            try {
                URL uRL = this.mapBase.resolve(uRI2).toURL();
                if (!bl) {
                    if (uRL.getProtocol().equalsIgnoreCase("file")) {
                        return new FileOutputStream(uRL.getFile());
                    }
                    throw new IllegalArgumentException("Can only save to file: scheme");
                }
                return new LazyURLInputStream(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                throw new JenaException(malformedURLException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new JenaException(iOException);
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Can only save to URLs");
        }
        if (this.zip != null) {
            return new LazyZipEntryInputStream(this.zip, string);
        }
        return TestInputStreamFactory.getInputStream(this.property + string);
    }

    private static InputStream getInputStream(String string) {
        ClassLoader classLoader = TestInputStreamFactory.class.getClassLoader();
        if (classLoader == null) {
            throw new SecurityException("Cannot access class loader");
        }
        InputStream inputStream = classLoader.getResourceAsStream("testing/" + string);
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream("testing/" + string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource: " + string + " not found on class path.");
            }
        }
        return inputStream;
    }
}

